/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.fid;

import de.lwsystems.mailarchive.bennoauth.common.utils.ClaimUtils;
import de.lwsystems.mailarchive.bennoauth.user.UserRepository;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public final class FederatedIdentityOAuth2TokenCustomizer
implements OAuth2TokenCustomizer<JwtEncodingContext> {
    UserRepository userRepository;
    private static final String ROLE = "role";
    private static final String BENNO_LOGIN_IDENTIFIER = "preferred_username";
    private static final String IDP_IDENTIFIER = "idp";
    private static final String USERNAME = "username";

    @Autowired
    public FederatedIdentityOAuth2TokenCustomizer(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public void customize(JwtEncodingContext context) {
        Assert.notNull((Object)context, (String)"JwtEncodingContext cannot be null");
        String tokenType = context.getTokenType().getValue();
        JwtClaimsSet.Builder claimsBuilder = context.getClaims();
        Map<String, Object> bennoUserClaims = new HashMap<String, Object>();
        String name = "";
        if (context.getPrincipal() instanceof OAuth2AuthenticationToken) {
            name = this.getUsernameFromOAuth2AuthenticationToken((OAuth2AuthenticationToken)context.getPrincipal());
        } else if (context.getPrincipal() instanceof UsernamePasswordAuthenticationToken) {
            name = this.getUsernameFromUsernamePasswordAuthenticationToken((UsernamePasswordAuthenticationToken)context.getPrincipal());
        }
        if (!name.isEmpty()) {
            bennoUserClaims = ClaimUtils.getClaimsFromDatabase(name, this.userRepository);
        }
        this.buildClaimsBuilder(claimsBuilder, bennoUserClaims, tokenType);
    }

    private String getUsernameFromOAuth2AuthenticationToken(OAuth2AuthenticationToken oAuth2AuthenticationToken) {
        Map<String, Object> thirdPartyClaims;
        if (oAuth2AuthenticationToken.getAuthorizedClientRegistrationId().contains(IDP_IDENTIFIER) && (thirdPartyClaims = this.extractClaims((Authentication)oAuth2AuthenticationToken)).containsKey(BENNO_LOGIN_IDENTIFIER)) {
            return thirdPartyClaims.get(BENNO_LOGIN_IDENTIFIER).toString();
        }
        return "";
    }

    private String getUsernameFromUsernamePasswordAuthenticationToken(UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken) {
        return usernamePasswordAuthenticationToken.getName();
    }

    private void buildClaimsBuilder(JwtClaimsSet.Builder claimsBuilder, Map<String, Object> bennoUserClaims, String tokenType) {
        if (bennoUserClaims.containsKey(USERNAME)) {
            claimsBuilder.claim("name", bennoUserClaims.get(USERNAME));
            claimsBuilder.claim("sub", bennoUserClaims.get(USERNAME));
        }
        if (bennoUserClaims.containsKey(ROLE)) {
            claimsBuilder.claim(ROLE, bennoUserClaims.get(ROLE));
        }
        if (tokenType.equals("id_token")) {
            claimsBuilder.claim("user", bennoUserClaims);
        }
    }

    private Map<String, Object> extractClaims(Authentication principal) {
        Map claims = Collections.emptyMap();
        if (principal.getPrincipal() instanceof OidcUser) {
            OidcIdToken idToken = ((OidcUser)principal.getPrincipal()).getIdToken();
            claims = idToken.getClaims();
        } else if (principal.getPrincipal() instanceof OAuth2User) {
            OAuth2User oauth2User = (OAuth2User)principal.getPrincipal();
            claims = oauth2User.getAttributes();
        }
        return new HashMap<String, Object>(claims);
    }
}

