/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.login;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsent;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AuthorizationConsentController {
    private static final Logger LOGGER = LogManager.getLogger(AuthorizationConsentController.class);
    private final RegisteredClientRepository registeredClientRepository;
    private final OAuth2AuthorizationConsentService authorizationConsentService;

    public AuthorizationConsentController(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationConsentService authorizationConsentService) {
        this.registeredClientRepository = registeredClientRepository;
        this.authorizationConsentService = authorizationConsentService;
    }

    @GetMapping(value={"/oauth2/consent"})
    public String consent(Principal principal, Model model, @RequestParam(value="client_id") String clientId, @RequestParam(value="scope") String scope, @RequestParam(value="state") String state) {
        HashSet<String> scopesToApprove = new HashSet<String>();
        HashSet<String> previouslyApprovedScopes = new HashSet<String>();
        RegisteredClient registeredClient = this.registeredClientRepository.findByClientId(clientId);
        if (registeredClient == null) {
            LOGGER.error("No client was found");
            throw new IllegalStateException("No client named " + clientId + " was found in the auth database.");
        }
        OAuth2AuthorizationConsent currentAuthorizationConsent = this.authorizationConsentService.findById(registeredClient.getId(), principal.getName());
        Set authorizedScopes = currentAuthorizationConsent != null ? currentAuthorizationConsent.getScopes() : Collections.emptySet();
        for (String requestedScope : StringUtils.delimitedListToStringArray((String)scope, (String)" ")) {
            if (authorizedScopes.contains(requestedScope)) {
                previouslyApprovedScopes.add(requestedScope);
                continue;
            }
            scopesToApprove.add(requestedScope);
        }
        model.addAttribute("clientId", (Object)clientId);
        model.addAttribute("state", (Object)state);
        model.addAttribute("scopes", AuthorizationConsentController.withDescription(scopesToApprove));
        model.addAttribute("previouslyApprovedScopes", AuthorizationConsentController.withDescription(previouslyApprovedScopes));
        String userName = principal.getName();
        if (principal instanceof OAuth2AuthenticationToken) {
            userName = ((OAuth2AuthenticationToken)principal).getPrincipal().getAttributes().get("preferred_username").toString();
        }
        model.addAttribute("principalName", (Object)userName);
        return "consent";
    }

    private static Set<ScopeWithDescription> withDescription(Set<String> scopes) {
        HashSet<ScopeWithDescription> scopeWithDescriptions = new HashSet<ScopeWithDescription>();
        for (String scope : scopes) {
            scopeWithDescriptions.add(new ScopeWithDescription(scope));
        }
        return scopeWithDescriptions;
    }

    public static class ScopeWithDescription {
        private static final String DEFAULT_DESCRIPTION = "UNKNOWN SCOPE - We cannot provide information about this permission, use caution when granting this.";
        private static final Map<String, String> scopeDescriptions = new HashMap<String, String>();
        public final String scope;
        public final String description;

        ScopeWithDescription(String scope) {
            this.scope = scope;
            this.description = scopeDescriptions.getOrDefault(scope, DEFAULT_DESCRIPTION);
        }

        static {
            scopeDescriptions.put("message.read", "This application will be able to read your message.");
            scopeDescriptions.put("message.write", "This application will be able to add new messages. It will also be able to edit and delete existing messages.");
            scopeDescriptions.put("other.scope", "This is another scope example of a scope description.");
        }
    }
}

