/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.login;

import de.lwsystems.mailarchive.bennoauth.login.error.ErrorResponse;
import de.lwsystems.mailarchive.bennoauth.login.error.ErrorResponseType;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class LoginController {
    private static final Logger LOGGER = LogManager.getLogger(LoginController.class);
    private boolean isError = false;
    private ErrorResponse errorResponse = null;

    @GetMapping(value={"/login"})
    public String login(HttpServletRequest request, Model model) {
        StringBuilder errorMessage = new StringBuilder();
        this.addStatusCodeIfItExists(request, errorMessage);
        this.addAuthenticationExceptionIfExists(request, errorMessage);
        if (this.isError) {
            model.addAttribute("errorResponse", (Object)this.errorResponse);
            this.isError = false;
            return "error";
        }
        return "login";
    }

    private void addStatusCodeIfItExists(HttpServletRequest request, StringBuilder errorMessage) {
        Object status = request.getAttribute("javax.servlet.error.status_code");
        if (status != null) {
            Integer statusCode = Integer.valueOf(status.toString());
            errorMessage.append(status.toString());
            if (statusCode.intValue() == HttpStatus.NOT_FOUND.value()) {
                errorMessage.append(": The user could not be logged in. Please check the transmitted client values.");
            }
        }
    }

    private void addAuthenticationExceptionIfExists(HttpServletRequest request, StringBuilder errorMessage) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            AuthenticationException ex = (AuthenticationException)session.getAttribute("SPRING_SECURITY_LAST_EXCEPTION");
            session.removeAttribute("SPRING_SECURITY_LAST_EXCEPTION");
            if (ex != null) {
                this.errorResponse = new ErrorResponse(ErrorResponseType.ERR_AUTHZ, ex.getMessage());
                errorMessage.append(this.errorResponse.getErrorTime()).append(": ERR_AUTHZ ").append(ex.getMessage() + this.errorResponse);
                LOGGER.error(errorMessage.toString(), (Object[])ex.getStackTrace());
                this.isError = true;
            }
        }
    }
}

