/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.oauthclient;

import de.lwsystems.mailarchive.bennoauth.oauthclient.OAuthClient;
import de.lwsystems.mailarchive.bennoauth.oauthclient.azure.AzureClient;
import de.lwsystems.mailarchive.bennoauth.oauthclient.azure.AzureData;
import de.lwsystems.mailarchive.bennoauth.oauthclient.generic.GenericClient;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class OauthClientFactory {
    AzureData azureData;
    private static final String ISSUER_IDENTIFIER = "iss";
    private static final String AZURE_IDENTIFIER = "microsoft";

    @Autowired
    public OauthClientFactory(AzureData azureData) {
        this.azureData = azureData;
    }

    public OAuthClient getOauthClient(OAuth2User oAuth2User) {
        Assert.notNull((Object)oAuth2User, (String)"OAuth2User cannot be null");
        if (oAuth2User.getAttribute(ISSUER_IDENTIFIER) != null && Objects.requireNonNull(oAuth2User.getAttribute(ISSUER_IDENTIFIER)).toString().contains(AZURE_IDENTIFIER)) {
            return this.getAzureClient(oAuth2User);
        }
        return new GenericClient(oAuth2User);
    }

    public OAuthClient getOauthClient(OAuth2User oAuth2User, String accessToken) {
        Assert.notNull((Object)oAuth2User, (String)"OAuth2User cannot be null");
        Assert.notNull((Object)accessToken, (String)"accessToken cannot be null");
        if (oAuth2User.getAttribute(ISSUER_IDENTIFIER) != null && Objects.requireNonNull(oAuth2User.getAttribute(ISSUER_IDENTIFIER)).toString().contains(AZURE_IDENTIFIER)) {
            return this.getAzureClient(oAuth2User, accessToken);
        }
        return new GenericClient(oAuth2User);
    }

    private OAuthClient getAzureClient(OAuth2User oAuth2User) {
        return new AzureClient(this.azureData, oAuth2User);
    }

    private OAuthClient getAzureClient(OAuth2User oAuth2User, String accessToken) {
        return new AzureClient(this.azureData, oAuth2User, accessToken);
    }
}

