/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.oauthclient.azure;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.GraphServiceClient;
import de.lwsystems.mailarchive.bennoauth.authentication.BennoUserParameter;
import de.lwsystems.mailarchive.bennoauth.oauthclient.OAuthClient;
import de.lwsystems.mailarchive.bennoauth.oauthclient.azure.AzureData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import okhttp3.Request;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.util.Assert;

public class AzureClient
implements OAuthClient {
    private static final Logger LOGGER = LogManager.getLogger(AzureClient.class);
    private GraphServiceClient<Request> graphServiceClient = null;
    private String clientId = "";
    private String clientSecret = "";
    private String selectParams = "";
    private String standardSelectParams = "";
    private String tenantId = "";
    private String accessToken = "";
    private String userEmail;
    private final List<String> scopes = new ArrayList<String>(List.of("https://graph.microsoft.com/.default"));
    private static final String GET_USER_ATTRIBUTE = "preferred_username";
    private static final String GET_NAME_ATTRIBUTE = "name";
    private static final String GET_TID_ATTRIBUTE = "tid";
    private static final String GET_OID_ATTRIBUTE = "oid";

    public AzureClient(AzureData azureData, OAuth2User oAuth2User) {
        Assert.notNull((Object)azureData, (String)"AzureData cannot be null");
        Assert.notNull((Object)oAuth2User, (String)"OAuth2User cannot be null");
        this.clientId = azureData.getClientId();
        this.clientSecret = azureData.getClientSecret();
        this.selectParams = azureData.getSelectParams();
        this.standardSelectParams = azureData.getStandardSelectParams();
        this.tenantId = (String)oAuth2User.getAttribute(GET_TID_ATTRIBUTE);
        boolean existsEmail = this.existsEmailInToken(oAuth2User);
        if (!existsEmail) {
            throw new IllegalArgumentException("Email doesn't exists in Azure token");
        }
    }

    public AzureClient(AzureData azureData, OAuth2User oAuth2User, String accessToken) {
        Assert.notNull((Object)oAuth2User, (String)"OAuth2User cannot be null");
        Assert.notNull((Object)accessToken, (String)"accessToken cannot be null");
        this.clientId = azureData.getClientId();
        this.clientSecret = azureData.getClientSecret();
        this.selectParams = azureData.getSelectParams();
        this.standardSelectParams = azureData.getStandardSelectParams();
        this.accessToken = accessToken;
        this.tenantId = (String)oAuth2User.getAttribute(GET_TID_ATTRIBUTE);
        boolean existsEmail = this.existsEmailInToken(oAuth2User);
        if (!existsEmail) {
            throw new IllegalArgumentException("Email doesn't exists in Azure token");
        }
    }

    private boolean existsEmailInToken(OAuth2User oAuth2User) {
        Assert.notNull((Object)oAuth2User, (String)"OAuth2User cannot be null");
        try {
            this.userEmail = Objects.requireNonNull(oAuth2User.getAttribute(GET_USER_ATTRIBUTE)).toString();
            return true;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    private void buildConnectionWithAccessToken() {
        IAuthenticationProvider authProvider = requestUrl -> {
            Assert.notNull((Object)requestUrl, (String)"requestUrl cannot be null");
            CompletableFuture<String> accessTokenProvider = new CompletableFuture<String>();
            accessTokenProvider.complete(this.accessToken);
            return accessTokenProvider;
        };
        this.graphServiceClient = GraphServiceClient.builder().authenticationProvider(authProvider).buildClient();
    }

    private void buildConnectionWithClient() {
        ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(this.clientId)).clientSecret(this.clientSecret).tenantId(this.tenantId)).build();
        TokenCredentialAuthProvider tokenCredentialAuthProvider = new TokenCredentialAuthProvider(this.scopes, (TokenCredential)clientSecretCredential);
        this.graphServiceClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredentialAuthProvider).buildClient();
    }

    private void buildConnection() {
        if (this.graphServiceClient == null) {
            if (!this.accessToken.equals("")) {
                this.buildConnectionWithAccessToken();
            } else {
                this.buildConnectionWithClient();
            }
        }
    }

    private Optional<User> getUserInfoWithAccessToken(String select) {
        try {
            if (select.isEmpty()) {
                return Optional.ofNullable(this.graphServiceClient.me().buildRequest(new Option[0]).get());
            }
            LOGGER.debug("Select parameters for Azure me endpoint are {}", (Object)select);
            return Optional.ofNullable(this.graphServiceClient.me().buildRequest(new Option[0]).select(select).get());
        }
        catch (GraphServiceException | NullPointerException ex) {
            return Optional.empty();
        }
    }

    private Optional<User> getUserInfoWithClient(OAuth2User oAuth2User, String select) {
        try {
            if (select.isEmpty()) {
                return Optional.ofNullable(this.graphServiceClient.users(Objects.requireNonNull((String)oAuth2User.getAttribute(GET_OID_ATTRIBUTE))).buildRequest(new Option[0]).get());
            }
            return Optional.ofNullable(this.graphServiceClient.users(Objects.requireNonNull((String)oAuth2User.getAttribute(GET_OID_ATTRIBUTE))).buildRequest(new Option[0]).select(select).get());
        }
        catch (GraphServiceException | NullPointerException ex) {
            return Optional.empty();
        }
    }

    @Override
    public BennoUserParameter getUserParameters(OAuth2User oAuth2User) {
        this.buildConnection();
        BennoUserParameter bennoUserParameter = new BennoUserParameter();
        try {
            Optional<User> optUser = this.accessToken.equals("") ? this.getUserInfoWithClient(oAuth2User, "") : this.getUserInfoWithAccessToken("");
            if (optUser.isPresent()) {
                User user = optUser.get();
                bennoUserParameter.setUserId(user.userPrincipalName);
                bennoUserParameter.setDisplayName(user.displayName);
                if (user.mail != null) {
                    bennoUserParameter.setMails(new HashSet<String>(Collections.singletonList(user.mail)));
                }
            }
        }
        catch (GraphServiceException | NullPointerException ex) {
            bennoUserParameter.setDisplayName((String)oAuth2User.getAttribute(GET_NAME_ATTRIBUTE));
            bennoUserParameter.setUserId((String)oAuth2User.getAttribute(GET_USER_ATTRIBUTE));
            bennoUserParameter.setMails(new HashSet<String>(Collections.singletonList(Objects.requireNonNull(oAuth2User.getAttribute(GET_USER_ATTRIBUTE)).toString())));
        }
        bennoUserParameter.setRoles(new HashSet<String>(List.of("User")));
        return bennoUserParameter;
    }

    @Override
    public Map<String, Object> getAdditionalUserInformation(OAuth2User oAuth2User) {
        this.buildConnection();
        ObjectMapper oMapper = new ObjectMapper();
        StringBuilder selectParameters = new StringBuilder();
        if (this.selectParams != null) {
            selectParameters.append(this.selectParams);
        } else {
            selectParameters.append(this.standardSelectParams);
        }
        Optional<User> optUser = this.accessToken.equals("") ? this.getUserInfoWithClient(oAuth2User, selectParameters.toString()) : this.getUserInfoWithAccessToken(selectParameters.toString());
        if (optUser.isPresent()) {
            User user = optUser.get();
            return (Map)oMapper.convertValue((Object)user, Map.class);
        }
        return new HashMap<String, Object>();
    }

    @Override
    public String getUserEmail() {
        return this.userEmail;
    }
}

