/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.oauthclient.generic;

import com.microsoft.graph.http.GraphServiceException;
import de.lwsystems.mailarchive.bennoauth.authentication.BennoUserParameter;
import de.lwsystems.mailarchive.bennoauth.oauthclient.OAuthClient;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.springframework.security.oauth2.core.user.OAuth2User;

public class GenericClient
implements OAuthClient {
    private String userEmail;
    private static final String GET_USER_ATTRIBUTE = "email";
    private static final String GET_NAME_ATTRIBUTE = "name";

    public GenericClient(@NotNull OAuth2User oAuth2User) {
        boolean existsEmail = this.existsEmailInToken(oAuth2User);
        if (!existsEmail) {
            throw new IllegalArgumentException("Email doesn't exists in Azure token");
        }
    }

    private boolean existsEmailInToken(OAuth2User oAuth2User) {
        try {
            this.userEmail = Objects.requireNonNull(oAuth2User.getAttribute(GET_USER_ATTRIBUTE)).toString();
            return true;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    @Override
    public BennoUserParameter getUserParameters(OAuth2User oAuth2User) {
        BennoUserParameter bennoUserParameter = new BennoUserParameter();
        try {
            bennoUserParameter.setContainers(new HashSet<String>(List.of()));
            bennoUserParameter.setDisplayName((String)oAuth2User.getAttribute(GET_NAME_ATTRIBUTE));
            bennoUserParameter.setUserId((String)oAuth2User.getAttribute(GET_USER_ATTRIBUTE));
            bennoUserParameter.setMails(new HashSet<String>(Collections.singletonList(Objects.requireNonNull(oAuth2User.getAttribute(GET_USER_ATTRIBUTE)).toString())));
        }
        catch (GraphServiceException | NullPointerException ex) {
            bennoUserParameter.setContainers(new HashSet<String>(List.of()));
            bennoUserParameter.setDisplayName("");
            bennoUserParameter.setUserId("");
            bennoUserParameter.setMails(new HashSet<String>(List.of()));
        }
        bennoUserParameter.setRoles(new HashSet<String>(List.of("User")));
        return bennoUserParameter;
    }

    @Override
    public Map<String, Object> getAdditionalUserInformation(OAuth2User oAuth2User) {
        return new HashMap<String, Object>();
    }

    @Override
    public String getUserEmail() {
        return this.userEmail;
    }
}

