/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.user;

import de.lwsystems.mailarchive.bennoauth.authentication.BennoUserParameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Transient;
import org.json.JSONObject;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;

@Entity
public class User
implements UserDetails,
Serializable {
    private String displayUsername;
    @Id
    private String username;
    @Transient
    private Set<String> email;
    @Column(columnDefinition="TEXT")
    private String parameter;
    private String password;
    @Transient
    private Set<String> container;
    @Transient
    private Set<String> filter;
    @Transient
    private Set<String> roles;
    @Transient
    private List<GrantedAuthority> grantedAuthorities = new ArrayList<GrantedAuthority>();

    public User() {
    }

    public User(String username, String password, BennoUserParameter bennoUserParameter, List<GrantedAuthority> grantedAuthorities) {
        Assert.notNull((Object)username, (String)"username cannot be null");
        Assert.notNull((Object)username, (String)"password cannot be null");
        Assert.notNull((Object)username, (String)"bennoUserParameter cannot be null");
        Assert.notNull((Object)username, (String)"grantedAuthorities cannot be null");
        this.username = username;
        this.password = password;
        this.displayUsername = Objects.requireNonNull(bennoUserParameter.getDisplayName());
        this.email = Objects.requireNonNull(bennoUserParameter.getMails());
        this.container = Objects.requireNonNull(bennoUserParameter.getContainers());
        this.filter = Objects.requireNonNull(bennoUserParameter.getFilter());
        this.roles = Objects.requireNonNull(bennoUserParameter.getRoles());
        this.grantedAuthorities = grantedAuthorities;
        this.parameter = this.buildJsonParameter();
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.grantedAuthorities;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getDisplayUsername() {
        return this.displayUsername;
    }

    public Set<String> getEmail() {
        return this.email;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public Set<String> getContainer() {
        return this.container;
    }

    public Set<String> getFilter() {
        return this.filter;
    }

    private String buildJsonParameter() {
        JSONObject bennoParameters = new JSONObject();
        bennoParameters.put("containers", this.container);
        bennoParameters.put("displayUsername", (Object)this.displayUsername);
        bennoParameters.put("username", (Object)this.username);
        bennoParameters.put("mails", this.email);
        if (this.roles.iterator().hasNext()) {
            bennoParameters.put("role", (Object)this.roles.iterator().next());
        } else {
            bennoParameters.put("role", (Object)"");
        }
        return bennoParameters.toString();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public String getParameterJsonString() {
        return this.parameter;
    }
}

