/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.user;

import de.lwsystems.mailarchive.bennoauth.exception.AccessDataNotCorrectException;
import de.lwsystems.mailarchive.bennoauth.user.User;
import de.lwsystems.mailarchive.bennoauth.user.UserRepository;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class UserDetailsServiceImpl
implements UserDetailsService {
    UserRepository userRepository;

    public UserDetailsServiceImpl(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public UserDetails loadUserByUsername(String username) throws AccessDataNotCorrectException {
        Assert.notNull((Object)username, (String)"username cannot be null");
        if (username.isEmpty()) {
            throw new IllegalArgumentException("username cannot be empty");
        }
        User user = this.userRepository.findByUsername(username);
        if (user == null) {
            throw new UsernameNotFoundException(username + " was not found in benno");
        }
        return user;
    }
}

