/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.user;

import de.lwsystems.mailarchive.bennoauth.authentication.BennoUserParameter;
import de.lwsystems.mailarchive.bennoauth.authentication.ThirdPartyAuthenticationService;
import de.lwsystems.mailarchive.bennoauth.authentication.service.AuthenticationFactory;
import de.lwsystems.mailarchive.bennoauth.authentication.service.userinfoauth.UserinfoAuthRequestParameter;
import de.lwsystems.mailarchive.bennoauth.authentication.user.AuthenticationUserService;
import de.lwsystems.mailarchive.bennoauth.common.utils.BennoUserParametersUtils;
import de.lwsystems.mailarchive.bennoauth.exception.AttributeNotFoundException;
import de.lwsystems.mailarchive.bennoauth.exception.AuthConnectionException;
import de.lwsystems.mailarchive.bennoauth.oauthclient.OAuthClient;
import de.lwsystems.mailarchive.bennoauth.oauthclient.OauthClientFactory;
import de.lwsystems.mailarchive.bennoauth.user.User;
import de.lwsystems.mailarchive.bennoauth.user.UserRepository;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public final class UserRepositoryOAuth2UserHandler
implements Consumer<OAuth2User> {
    private static final Logger LOGGER = LogManager.getLogger(UserRepositoryOAuth2UserHandler.class);
    private OauthClientFactory oAuthClientFactory;
    private AuthenticationUserService authenticationUserService;
    private UserRepository userRepository;
    private OAuth2AuthorizedClientService oAuth2AuthorizedClientService;

    public UserRepositoryOAuth2UserHandler(OauthClientFactory oAuthClientFactory, AuthenticationUserService authenticationUserService, UserRepository userRepository, OAuth2AuthorizedClientService oAuth2AuthorizedClientService) {
        this.oAuthClientFactory = oAuthClientFactory;
        this.authenticationUserService = authenticationUserService;
        this.userRepository = userRepository;
        this.oAuth2AuthorizedClientService = oAuth2AuthorizedClientService;
    }

    private Optional<User> getBennoUserFromAuthenticationService(String userEmail, Map<String, Object> additionalUserInfo) {
        try {
            ThirdPartyAuthenticationService thirdPartyAuthenticationService = (ThirdPartyAuthenticationService)AuthenticationFactory.getAuthenticationService();
            return thirdPartyAuthenticationService.getUserFromAuthenticationService(userEmail, additionalUserInfo);
        }
        catch (UsernameNotFoundException ex) {
            LOGGER.info("{} doesn't exists in benno", (Object)userEmail);
        }
        catch (IOException ex) {
            throw new AuthConnectionException(ex);
        }
        return Optional.empty();
    }

    private void createBennoUser(Optional<User> bennoUser, BennoUserParameter bennoUserParameter, String userEmail) {
        User user;
        if (bennoUser.isEmpty()) {
            bennoUser = Optional.ofNullable(this.authenticationUserService.createUser(bennoUserParameter.getUserId(), UUID.randomUUID().toString(), bennoUserParameter));
        } else {
            user = bennoUser.get();
            bennoUser = Optional.ofNullable(this.authenticationUserService.createUser(user.getUsername(), user.getPassword(), BennoUserParametersUtils.mergeUserAndBennoUserParameters(bennoUser.get(), bennoUserParameter)));
        }
        if (!bennoUser.isPresent()) {
            throw new UsernameNotFoundException(userEmail + " was not found in benno");
        }
        user = bennoUser.get();
        this.userRepository.save(user);
    }

    private String getAccessTokenIfExists() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            String principalName;
            String clientId = ((OAuth2AuthenticationToken)authentication).getAuthorizedClientRegistrationId();
            OAuth2AuthorizedClient oAuth2AuthorizedClient = this.oAuth2AuthorizedClientService.loadAuthorizedClient(clientId, principalName = authentication.getName());
            if (oAuth2AuthorizedClient.getAccessToken().getTokenValue().isEmpty()) {
                return "";
            }
            return oAuth2AuthorizedClient.getAccessToken().getTokenValue();
        }
        return "";
    }

    private Map<String, Object> prepareUserValuesForUserinfoAuth(OAuth2User oAuth2User, OAuthClient oAuthClient) {
        HashMap<String, Object> additionalUserInfo = new HashMap<String, Object>();
        try {
            additionalUserInfo.put(UserinfoAuthRequestParameter.EXTERNAL_OIDC_TOKEN.getName(), ((OidcUser)oAuth2User).getIdToken().getTokenValue());
        }
        catch (ClassCastException | NullPointerException ex) {
            additionalUserInfo.put(UserinfoAuthRequestParameter.EXTERNAL_OIDC_TOKEN.getName(), "no-oidc-token");
        }
        additionalUserInfo.put("additional_user_infos", oAuthClient.getAdditionalUserInformation(oAuth2User));
        return additionalUserInfo;
    }

    @Override
    public void accept(OAuth2User oAuth2User) {
        Assert.notNull((Object)oAuth2User, (String)"OAuth2User cannot be null");
        String accessToken = this.getAccessTokenIfExists();
        OAuthClient oAuthClient = accessToken.isEmpty() ? this.oAuthClientFactory.getOauthClient(oAuth2User) : this.oAuthClientFactory.getOauthClient(oAuth2User, accessToken);
        Optional<String> userAttribute = Optional.ofNullable(oAuthClient.getUserEmail());
        if (!userAttribute.isPresent()) {
            throw new AttributeNotFoundException("User can't identified and the extern auth provider is not supported");
        }
        String userEmail = userAttribute.get();
        Optional<User> bennoUser = this.getBennoUserFromAuthenticationService(userEmail, this.prepareUserValuesForUserinfoAuth(oAuth2User, oAuthClient));
        BennoUserParameter bennoUserParameter = oAuthClient.getUserParameters(oAuth2User);
        this.createBennoUser(bennoUser, bennoUserParameter, userEmail);
    }
}

