/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.userinfo;

import de.lwsystems.mailarchive.bennoauth.authentication.service.AuthenticationFactory;
import de.lwsystems.mailarchive.bennoauth.common.utils.ClaimUtils;
import de.lwsystems.mailarchive.bennoauth.exception.AuthConnectionException;
import de.lwsystems.mailarchive.bennoauth.exception.AuthNotFoundException;
import de.lwsystems.mailarchive.bennoauth.user.UserRepository;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcUserInfoAuthenticationContext;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcUserInfoAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class Userinfo {
    private static final Logger LOGGER = LogManager.getLogger(Userinfo.class);
    private final UserRepository userRepository;
    private static final List<String> AUTH_ELEMENTS = Arrays.asList("containers", "mails");
    private static final String USER_CLAIM = "user";
    private static final String ROLE_CLAIM = "role";

    @Autowired
    public Userinfo(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public OidcUserInfo getOidcClaims(OidcUserInfoAuthenticationContext oidcUserInfoAuthenticationContext) {
        Assert.notNull((Object)oidcUserInfoAuthenticationContext, (String)"oidcUserInfoAuthenticationContext cannot be null");
        JwtAuthenticationToken jwtAuthenticationToken = this.getJwtAuthenticationToken(oidcUserInfoAuthenticationContext);
        String username = jwtAuthenticationToken.getTokenAttributes().get("name").toString();
        HashMap<String, Object> claims = new HashMap<String, Object>(((Jwt)jwtAuthenticationToken.getToken()).getClaims());
        Map<String, Object> bennoUserClaims = this.getBennoUserClaims(username);
        claims.put(USER_CLAIM, bennoUserClaims);
        claims.put(ROLE_CLAIM, bennoUserClaims.get(ROLE_CLAIM));
        LOGGER.debug("Create OIDC Token for response with following data {} ", (Object)((Object)claims).toString());
        return new OidcUserInfo(claims);
    }

    private Map<String, Object> getBennoUserClaims(String username) {
        Map<Object, Object> bennoUserClaims = new HashMap();
        try {
            bennoUserClaims = this.getUserClaimsFromAuthService(username);
            if (bennoUserClaims.isEmpty()) {
                bennoUserClaims = ClaimUtils.getClaimsFromDatabase(username, this.userRepository);
            } else {
                Map<String, Object> bennoUserClaimsDatabase = this.getUserClaimsFromAuthDatabase(username);
                this.setElementsFromAuthDatabaseToBennoUserClaims(bennoUserClaims, bennoUserClaimsDatabase);
            }
        }
        catch (AuthConnectionException | AuthNotFoundException | IOException ex) {
            bennoUserClaims = ClaimUtils.getClaimsFromDatabase(username, this.userRepository);
        }
        return bennoUserClaims;
    }

    private JwtAuthenticationToken getJwtAuthenticationToken(OidcUserInfoAuthenticationContext oidcUserInfoAuthenticationContext) {
        OidcUserInfoAuthenticationToken authentication = (OidcUserInfoAuthenticationToken)oidcUserInfoAuthenticationContext.getAuthentication();
        return (JwtAuthenticationToken)authentication.getPrincipal();
    }

    private Map<String, Object> getUserClaimsFromAuthService(String username) throws IOException {
        return ClaimUtils.getClaimsFromAuthService(username, this.userRepository, AuthenticationFactory.getAuthenticationService());
    }

    private Map<String, Object> getUserClaimsFromAuthDatabase(String username) {
        return ClaimUtils.getClaimsFromDatabase(username, this.userRepository);
    }

    private void setElementsFromAuthDatabaseToBennoUserClaims(Map<String, Object> bennoUserClaims, Map<String, Object> bennoUserClaimsDatabase) {
        for (String claimToAddElement : AUTH_ELEMENTS) {
            ArrayList claimsToAdd = new ArrayList();
            if (bennoUserClaims.containsKey(claimToAddElement)) {
                try {
                    claimsToAdd.addAll((List)bennoUserClaims.get(claimToAddElement));
                    claimsToAdd.addAll((List)bennoUserClaimsDatabase.get(claimToAddElement));
                }
                catch (ClassCastException ex) {
                    LOGGER.warn("Cannot add claims to oidc token", (Throwable)ex);
                }
            }
            bennoUserClaims.put(claimToAddElement, claimsToAdd);
        }
    }
}

