/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.validator;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import de.lwsystems.mailarchive.bennoauth.validator.TokenValidator;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.springframework.security.oauth2.client.oidc.authentication.OidcIdTokenValidator;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;

public class OIDCTokenValidator
implements TokenValidator {
    private ClientRegistration clientRegistration;
    private ConfigurableJWTProcessor<SecurityContext> jwtProcessor;
    private JWT oidcToken;
    private String token;

    public OIDCTokenValidator(ClientRegistrationRepository clientRegistrationRepository, String token, String clientId) {
        this.clientRegistration = clientRegistrationRepository.findByRegistrationId(clientId);
        this.token = token;
        try {
            this.oidcToken = JWTParser.parse((String)this.token);
        }
        catch (ParseException ex) {
            throw new OAuth2AuthenticationException("The oidc token is not valid. " + ex.getMessage());
        }
    }

    @Override
    public boolean checkTokenClaims() {
        OidcIdTokenValidator oidcIdTokenValidator = new OidcIdTokenValidator(this.clientRegistration);
        try {
            Jwt jwt = new Jwt(this.oidcToken.getParsedString(), Instant.ofEpochSecond(this.oidcToken.getJWTClaimsSet().getIssueTime().getTime() / 1000L), Instant.ofEpochSecond(this.oidcToken.getJWTClaimsSet().getExpirationTime().getTime() / 1000L), this.oidcToken.getHeader().toJSONObject(), new LinkedHashMap(this.oidcToken.getJWTClaimsSet().getClaims()));
            OAuth2TokenValidatorResult result = oidcIdTokenValidator.validate(jwt);
            if (result.hasErrors()) {
                throw new OAuth2AuthenticationException("The oidc token is not valid. " + result.getErrors().toString());
            }
        }
        catch (ParseException ex) {
            throw new OAuth2AuthenticationException("Can't parse oidc token. " + ex.getMessage());
        }
        return true;
    }

    private void initJwtProcessor() throws MalformedURLException, ParseException {
        SignedJWT signedJWT = SignedJWT.parse((String)this.token);
        this.jwtProcessor = new DefaultJWTProcessor();
        this.jwtProcessor.setJWSTypeVerifier((JOSEObjectTypeVerifier)new DefaultJOSEObjectTypeVerifier(new JOSEObjectType[]{new JOSEObjectType("jwt")}));
        RemoteJWKSet keySource = new RemoteJWKSet(new URL(this.clientRegistration.getProviderDetails().getJwkSetUri()));
        JWSAlgorithm expectedJWSAlg = JWSAlgorithm.parse((String)this.oidcToken.getHeader().getAlgorithm().getName());
        JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(expectedJWSAlg, (JWKSource)keySource);
        this.jwtProcessor.setJWSKeySelector((JWSKeySelector)keySelector);
        this.jwtProcessor.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)new DefaultJWTClaimsVerifier(new JWTClaimsSet.Builder().issuer(signedJWT.getJWTClaimsSet().getIssuer()).build(), new HashSet<String>(Arrays.asList("sub", "iat", "exp"))));
    }

    @Override
    public boolean checkTokenSignature() {
        try {
            this.initJwtProcessor();
            this.jwtProcessor.process(this.token, null);
        }
        catch (JOSEException | BadJOSEException | RuntimeException | MalformedURLException | ParseException ex) {
            throw new OAuth2AuthenticationException("Can't validate oidc token. " + ex.getMessage());
        }
        return true;
    }
}

