#!/bin/sh
# postinst script for benno-auth
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postinst> `configure' <most-recently-configured-version>
#        * <old-postinst> `abort-upgrade' <new version>
#        * <conflictor's-postinst> `abort-remove' `in-favour' <package>
#          <new-version>
#        * <postinst> `abort-remove'
#        * <deconfigured's-postinst> `abort-deconfigure' `in-favour'
#          <failed-install-package> <version> `removing'
#          <conflicting-package> <version>
# for details, see https://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    install|upgrade)

    ;;
    configure)
        [ -z "$DAEMON_USER" ]  && DAEMON_USER=bennoauth
        [ -z "$DAEMON_GROUP" ] && DAEMON_GROUP=bennoauth
        [ -z "$DAEMON_CONF" ]  && DAEMON_CONF=/etc/benno-auth/auth.yml
        [ -z "$CLIENT_CONF" ]  && CLIENT_CONF=/etc/benno-auth/clients/bennoweb.yml
        [ -z "$WEBSRV_GROUP" ] && WEBSRV_GROUP=www-data
        [ -z "$ERROR_TPL" ]    && ERROR_TPL=/etc/benno-auth/templates/benno2/error.html

        if ! dpkg-statoverride --list $CLIENT_CONF >/dev/null
        then
            chown $DAEMON_USER:$WEBSRV_GROUP $CLIENT_CONF
            chmod u=r,g=r,o= $CLIENT_CONF
        fi

        if grep -q CHANGE_BENNOAUTH_CLIENT_TOKEN $CLIENT_CONF 2>/dev/null; then
            NEW_TOKEN=$(dd if=/dev/urandom bs=1k count=1 status=none | tr -dc 'a-zA-Z0-9' | fold -w 20 | head -n 1 )
            perl -pi -se 's/CHANGE_BENNOAUTH_CLIENT_TOKEN/$new_token/' -- -new_token="$NEW_TOKEN"  $CLIENT_CONF
            perl -pi -se 's/CHANGE_BENNOAUTH_CLIENT_TOKEN/$new_token/' -- -new_token="$NEW_TOKEN"  $DAEMON_CONF
        fi

        if grep -q CHANGE_BENNOWEBCLIENT_SECRET $CLIENT_CONF 2>/dev/null; then
            NEW_SECRET=$(dd if=/dev/urandom bs=1k count=1 status=none | tr -dc 'a-zA-Z0-9' | fold -w 20 | head -n 1 )
            perl -pi -se 's/CHANGE_BENNOWEBCLIENT_SECRET/$new_secret/' -- -new_secret="$NEW_SECRET" $CLIENT_CONF
        fi

        if grep -q CHANGE_BENNOAUTH_CLIENT_TOKEN $CLIENT_CONF 2>/dev/null; then
            NEW_TOKEN=$(dd if=/dev/urandom bs=1k count=1 status=none | tr -dc 'a-zA-Z0-9' | fold -w 20 | head -n 1 )
            perl -pi -se 's/CHANGE_BENNOAUTH_CLIENT_TOKEN/$new_token/' -- -new_token="$NEW_TOKEN"  $CLIENT_CONF
            perl -pi -se 's/CHANGE_BENNOAUTH_CLIENT_TOKEN/$new_token/' -- -new_token="$NEW_TOKEN"  $DAEMON_CONF
        fi

        if grep -q CHANGE_HOSTNAME $CLIENT_CONF 2>/dev/null; then
            NEW_HOSTNAME=$(hostname -f)
            perl -pi -se 's/CHANGE_HOSTNAME/$new_hostname/' -- -new_hostname="$NEW_HOSTNAME"  $CLIENT_CONF
            perl -pi -se 's/CHANGE_HOSTNAME/$new_hostname/' -- -new_hostname="$NEW_HOSTNAME"  $DAEMON_CONF
            perl -pi -se 's/CHANGE_HOSTNAME/$new_hostname/' -- -new_hostname="$NEW_HOSTNAME"  $ERROR_TPL
        fi

        if grep -q CHANGE_AZURE $DAEMON_CONF 2>/dev/null; then
            echo "Please set client-id and client-secret in /etc/benno-auth/auth.yml"
            echo "and restart benno-auth service"
        fi

        if [ -d /etc/apache2/conf-enabled ];then
            [ -L /etc/apache2/conf-available/benno-oauth2.conf ] || ( ln -s /etc/benno-auth/apache2.conf /etc/apache2/conf-available/benno-oauth2.conf && a2enconf benno-oauth2.conf )
        fi
        a2enmod cgi proxy proxy_http
        systemctl reload apache2

        
        #systemctl restart apache2
        #systemctl restart benno-auth
    ;;

    abort-upgrade|abort-remove|abort-deconfigure)
    ;;

    *)
        echo "postinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.

# Automatically added by dh_installsystemd/13.11.4
if [ "$1" = "configure" ] || [ "$1" = "abort-upgrade" ] || [ "$1" = "abort-deconfigure" ] || [ "$1" = "abort-remove" ] ; then
	# The following line should be removed in trixie or trixie+1
	deb-systemd-helper unmask 'benno-auth.service' >/dev/null || true

	# was-enabled defaults to true, so new installations run enable.
	if deb-systemd-helper --quiet was-enabled 'benno-auth.service'; then
		# Enables the unit on first installation, creates new
		# symlinks on upgrades if the unit file has changed.
		deb-systemd-helper enable 'benno-auth.service' >/dev/null || true
	else
		# Update the statefile to add new symlinks (if any), which need to be
		# cleaned up on purge. Also remove old symlinks.
		deb-systemd-helper update-state 'benno-auth.service' >/dev/null || true
	fi
fi
# End automatically added section
# Automatically added by dh_installsystemd/13.11.4
if [ "$1" = "configure" ] || [ "$1" = "abort-upgrade" ] || [ "$1" = "abort-deconfigure" ] || [ "$1" = "abort-remove" ] ; then
	if [ -d /run/systemd/system ]; then
		systemctl --system daemon-reload >/dev/null || true
		if [ -n "$2" ]; then
			_dh_action=restart
		else
			_dh_action=start
		fi
		deb-systemd-invoke $_dh_action 'benno-auth.service' >/dev/null || true
	fi
fi
# End automatically added section


exit 0
