<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */
class YAMLConfig
{

  /**
    * Constructor
    *
    * @access public
    * @param string $filename
    * @return object
    */
    function __construct($filename)
    {
        global $App;
        $App->log("Read config file $filename",3,'YAMLConfig');
        $this->config = yaml_parse_file($filename);

        return $this;
    }

  /**
    * getParam
    *
    * Get value of parameter.
    *
    * Colon(:) is hierarchy separator: "first:second:third"
    *    first:
    *      second:
    *        third:
    *
    * @access public
    * @param string $parameter
    * @param string $default (optional)
    * @return object
    */
    function getConfig($param,$default='')
    {
        global $App;
        $ret = '';

        $params = explode(':',$param);
        $pcount = count($params);
        switch ($pcount) {
            case(4):
                $ret = @$this->config[$params[0]][$params[1]][$params[2]][$params[3]];
                break;
            case(3):
                $ret = @$this->config[$params[0]][$params[1]][$params[2]];
                break;
            case(2):
                $ret = @$this->config[$params[0]][$params[1]];
                break;
            case(1):
                $ret = @$this->config[$params[0]];
                break;
        }

        if (!isset($ret)) {
            $App->log("Config parameter $param does not exist",2,'YAMLConfig');
            if ($default) {
                return $default;
            }
        }

        return $ret;
    }

}
?>
