<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */
require_once 'init_config.php';


define('BNO_AUTH',      0b00000010);   //   2 user authenticated
define('BNO_USER',      0b00000100);   //   4 edit user
define('BNO_USERADMIN', 0b00001000);   //   8 user admin (change password, userinfo)
define('BNO_SYSINFO',   0b00010000);   //  16 see sysinfo / SYSDATA container
define('BNO_ADMIN',     0b00100000);   //  32 admin (change address, role)
define('BNO_SITEADMIN', 0b01000000);   //  64 siteadmin (change container, siteadmin role)


$clientId       = $AuthConf->getConfig('clientId');
$clientSecret   = $AuthConf->getConfig('clientSecret');

$authAccessUri  = $AuthConf->getConfig('rest:authAccessUri');
$authScope      = $AuthConf->getConfig('rest:authScope');
$redirectUri    = $AuthConf->getConfig('rest:redirectUri');
$benno2login    = $AuthConf->getConfig('rest:benno2Login');
$sslVerify      = $AuthConf->getConfig('rest:sslVerify');

if ($p_error = $App->getParam('error')) {
    $error_description = $App->getParam('error_description');
    redirect_error($benno2login,'ERR_INTERN',$p_error.' => '.$error_description);
}

$postData = "grant_type=authorization_code&scope=$authScope&redirect_uri=$redirectUri&code=$authCode";

$curl = curl_init();
curl_setopt($curl, CURLOPT_URL, $authAccessUri);
curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($curl, CURLOPT_HEADER, 1);
curl_setopt($curl, CURLOPT_POST, 1);
curl_setopt($curl, CURLOPT_POSTFIELDS, $postData);
// suppress using of 100-Continue requests
curl_setopt($curl, CURLOPT_HTTPHEADER,array("Expect:"));
curl_setopt($curl, CURLOPT_USERPWD, $clientId.':'.$clientSecret); 
if (preg_match('/^https:/',$authAccessUri)) {
    if ($sslVerify) {
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 2);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
    }
    else {
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
    }
}

$App->log('Request URL: '.$authAccessUri."?".$postData,4,'OAUTH2/access');
if (($response = curl_exec($curl)) === false) {
    $errnum = curl_errno($curl);
    redirect_error($benno2login,'ERR_INTERN','Request error: '.curl_error($curl).'['.$errnum.']');
}
$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE); 
if ($httpCode != 200) {
    redirect_error($benno2login,'ERR_INTERN','HTTP ERROR '.$httpCode.', query: "'.$authAccessUri.'"');
}

// split header / body
list($response_headers, $response_body) = explode("\r\n\r\n", $response, 2);
if ( !mb_check_encoding($response_body, 'UTF-8')) {
    $response_body = mb_convert_encoding($response_body, 'UTF-8');
}

$j_response = json_decode($response_body, true);
$id_body    = base64_decode($j_response['id_token']);

$id_body = preg_replace('/[\x00-\x1F\x7F]/', '', $id_body); // strip binary data
$id_data = preg_replace('/^{.+?}(.*?}).*$/', '\1}', $id_body); // strip binary data

$token_data = json_decode($id_data,true);
$App->log('Token data: '.json_encode($token_data),4,'OAUTH2/access');
$user_data  = $token_data['user'];

$USER = new User($user_data['username']);
$USER->name      = $user_data['displayUsername'];
$USER->role      = strtoupper($user_data['role']);
$USER->addresses = array_filter($user_data['mails']);
$USER->archive   = array_filter($user_data['containers']);


// init session data
$RESTconf = new ApplicationConfig($App->configdir);
$RESTconf->load($App->getConfig('REST_CONFIG','rest.conf'),false);

// defaults: compatibility to deprecated configuration
$base_url_mainconf = $App->getConfig('BASE_URL','http://localhost:21080');
$rest_data['URL']  = $RESTconf->getConfig('BASE_URL',$base_url_mainconf);
$rest_data['USER'] = $RESTconf->getConfig('REST_USER','benno2');
$rest_data['PASS'] = $RESTconf->getConfig('SHARED_SECRET',$App->getConfig('SHARED_SECRET'));

$USER->setRestData($rest_data);  // set defaults from config

// LOGIN SUCCESSFUL
$App->log('Authentication of '.$USER->id. ' successful',1,'OAUTH2/access');
$info_disabled = $App->getConfigList('INFO_DISABLED',array());
if (in_array('SYSDATA',$info_disabled)) {
    $USER->unsetPermission('SYSDATA');
}
$App->setSession('DISABLED',$info_disabled);

// initialize backend
$FilterList = Filter::FetchList($USER);
$filterString = '';
foreach ($FilterList as $Filter) {
    $filterString .= $Filter->getString();
}
if ($USER->getRole() == 'REVISOR') {
    $filterString = '*';
}

$rest_data = $USER->getRestData();
$Backend = new Backend($rest_data['URL'],$rest_data['USER'],$rest_data['PASS'],
                       $filterString);

// defaults for extended search form
$timerange = $App->getConfig('DEFAULT_TIMERANGE','30');
$ExtQuery = new Query('empty');
$App->setSession('ExtQuery',$ExtQuery);

$App->setSession('QueryList',StoredQuery::FetchList($USER->id));

// list of assigned archives
$archive_list = $USER->getArchives();
foreach ($archive_list as $archive) { // disable index counter if subarchives available
    @list($cidstring,$scid) = preg_split('/\/+(?=[^\/]+$)/',$archive);
    if ($scid) {
        // disable indexed mails counter always
        $DISABLED = $App->getSession('DISABLED');
        array_push($DISABLED,'INDEXCOUNT');
        $App->setSession('DISABLED',$DISABLED);
    }
}

// restore state of last session
try {
    // searchMask
    $AppState = new AppState($USER->id);
    $searchMaskState = $AppState->getValue('searchMaskState','Simple');
    $App->setSession('searchMaskState',$searchMaskState);
    $App->setSession('resendMailto',$AppState->getValue('resendMailto'));

    // handle deleted archives
    if (!in_array($AppState->getValue('archive'),$archive_list)) {
        $AppState->saveValue('archive','');
    }
    if (!$archive = $AppState->getValue('archive')) {
        $archive = end($archive_list);
    }

    // search SPAM
    $App->setSession('isSpam',$AppState->getValue('isSpam'));

    // Language
    if ($App->getParam('interfaceLanguage')) {
        $AppState->saveValue('userLanguage',$App->getParam('interfaceLanguage'));
        $App->setLang($App->getParam('interfaceLanguage'));
    }
    else {
        $userLanguage = $AppState->getValue('userLanguage');
        if ($userLanguage) {
            $App->setLang($userLanguage);
        }
    }
}
catch (Exception $e) {
    $App->log('Error loading application state: '.$e->getMessage(),0,'OAUTH2/access');
}

// initialize session
$App->setSession('ACCESS_LEVEL',1);
$App->setSession('USER',$USER);
$App->setSession('Backend',$Backend);   // store backend for this session
$App->setSession('archive',$archive);   // store current archive
$App->setSession('FilterList',$FilterList);

// set language on change and after login for 32 days
// Langage settings
if ($App->getParam('LANG')) {
    $LANG = $App->getParam('LANG');
    $App->setLang($LANG);
    $App->setSession('LANG',$LANG);
    // set language on change and after login for 32 days
    setcookie("BENNO_LANGUAGE", $LANG, time()+2764800, dirname($_SERVER['REQUEST_URI']));
}
elseif ($App->getSession('LANG')) {
    $App->setLang($App->getSession('LANG'));
}
else {
    if ($App->getConfig('FORCE_DEFAULT_LANGUAGE','false') == 'true') {
        $App->setLang($App->getConfig('DEFAULT_LANGUAGE','de'));
    }
    else {
        require_once 'model/AppUtils.php';
        $App->setLang(AppUtils::GetLocaleFromBrowser(
                        $App->getConfig('DEFAULT_LANGUAGE','de'),
                        false));
    }
}

setcookie("BENNO_LANGUAGE", $App->lang, time()+2764800, dirname($_SERVER['REQUEST_URI']));

$App->log("Redirect to $benno2login",1,'OAUTH2/access');
header('Location: '.$benno2login);
exit();

?>
