<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */
require_once 'init_config.php';

$redirectUri = $AuthConf->getConfig('rest:redirectUri');
$authScope   = $AuthConf->getConfig('rest:authScope','benno.read');

// Handle initial request
$scheme = $_SERVER['REQUEST_SCHEME'];
$vhost  = $_SERVER['SERVER_NAME'];
$vport  = $_SERVER['SERVER_PORT'];

$context_path = '/benno/v3.0';

$rport  = '';
if (($scheme == 'http') &! ($vport == 80)) {
    $rport = ':'.$vport;
}
else if (($scheme == 'https') &! ($vport == 443)) {
    $rport = ':'.$vport;
}

$path = $context_path."/oauth2/authorize?response_type=code&client_id=bennoweb&scope=$authScope&redirect_uri=$redirectUri";

header('Location: '.$scheme.'://'.$vhost.$rport.$path);
?>
