<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */
set_include_path('/srv/benno/bennoweb/htdocs:'.get_include_path());
require_once 'SPAF2/Application.php';
require_once 'model/User.php';
require_once 'model/return_exit.php';

$configfile = "/etc/benno-web/benno.conf";
$UNICODE=TRUE;

ob_start();
$App = new Application($configfile,$_REQUEST,'');

$conf_key = $App->getConfig('USERINFO_KEY');
$req_key  = $App->getParam('USERINFO_KEY');


// Authentication
if (!$conf_key) {
    $message = 'CONFIG ERROR: key missing';
    $App->log($message,1);
    auth_exit($message);
}
if (!$req_key) {
    $message = 'REQUEST ERROR: key missing';
    $App->log($message,1);
    auth_exit($message);
}
if ($req_key != $conf_key) {
    $message = 'REQUEST ERROR: request key does not match';
    $App->log($message,1);
    auth_exit($message);
}

$authscript  = $App->getConfig('EXTERNAL_AUTH','/usr/sbin/benno_auth.d');
putenv('REQUEST_TYPE=metadata');

$username = $App->getParam('USERNAME');
$passwd   = 'dummy';

$USER = new User($username);
try {
    if ($authscript && is_readable($authscript)) {
        $USER->loadExternal($authscript,$passwd);
    }
    else {
        $App->log("Cannot read \"$authscript\". Fallback authentication.");
        $USER->load();
        // check authentication
        if ($USER->password != md5($passwd)) {
            throw new Exception('ERR_AUTH');
        }
    }
}
catch (Exception $e) {
    // Authentication error -> redirect to login
    $message = $e->getMessage();
    $App->log($message);
    print($message);
}

json_exit($USER);
?>
