/*
IMPORTANT:
    If using PostgreSQL, update ALL columns defined with 'blob' to 'text',
    as PostgreSQL does not support the 'blob' data type.
*/
CREATE TABLE if not exists oauth2_authorization (
    id varchar(100) NOT NULL,
    registered_client_id varchar(100) NOT NULL,
    principal_name varchar(200) NOT NULL,
    authorization_grant_type varchar(100) NOT NULL,
    authorized_scopes varchar(1000) DEFAULT NULL,
    attributes blob DEFAULT NULL,
    state varchar(500) DEFAULT NULL,
    authorization_code_value blob DEFAULT NULL,
    authorization_code_issued_at timestamp DEFAULT 0,
    authorization_code_expires_at timestamp DEFAULT 0,
    authorization_code_metadata blob DEFAULT NULL,
    access_token_value blob DEFAULT NULL,
    access_token_issued_at timestamp DEFAULT 0,
    access_token_expires_at timestamp DEFAULT 0,
    access_token_metadata blob DEFAULT NULL,
    access_token_type varchar(100) DEFAULT NULL,
    access_token_scopes varchar(1000) DEFAULT NULL,
    oidc_id_token_value blob DEFAULT NULL,
    oidc_id_token_issued_at timestamp DEFAULT 0,
    oidc_id_token_expires_at timestamp DEFAULT 0,
    oidc_id_token_metadata blob DEFAULT NULL,
    refresh_token_value blob DEFAULT NULL,
    refresh_token_issued_at timestamp DEFAULT 0,
    refresh_token_expires_at timestamp DEFAULT 0,
    refresh_token_metadata blob DEFAULT NULL,
    PRIMARY KEY (id)
);

CREATE TABLE if not exists oauth2_authorization_consent (
    registered_client_id varchar(100) NOT NULL,
    principal_name varchar(200) NOT NULL,
    authorities varchar(1000) NOT NULL,
    PRIMARY KEY (registered_client_id, principal_name)
);

/*
IMPORTANT:
    MariaDB needs attribute client_secret_expires_at set as "timestamp NULL".

    FROM: https://mariadb.com/kb/en/timestamp/#automatic-values

    """
    MariaDB also has special behavior if NULL is assigned to column that
    uses the TIMESTAMP data type. If the column is assigned the NULL value
    in an INSERT or UPDATE query, then MariaDB will automatically initialize
    the column's value with the current date and time. For details, see NULL
    values in MariaDB.

    This automatic initialization for NULL values can also be explicitly
    disabled for a column that uses the TIMESTAMP data type by specifying
    the NULL attribute for the column. In this case, if the column's value
    is set to NULL, then the column's value will actually be set to NULL.
    see: https://mariadb.com/kb/en/timestamp/#automatic-values
    """
*/
CREATE TABLE if not exists oauth2_registered_client (
    id varchar(100) NOT NULL,
    client_id varchar(100) NOT NULL,
    client_id_issued_at timestamp DEFAULT CURRENT_TIMESTAMP,
    client_secret varchar(200) DEFAULT NULL,
    client_secret_expires_at timestamp NULL,
    client_name varchar(200) NOT NULL DEFAULT 0,
    client_authentication_methods varchar(1000) NOT NULL,
    authorization_grant_types varchar(1000) NOT NULL,
    redirect_uris varchar(1000) DEFAULT NULL,
    scopes varchar(1000) NOT NULL,
    client_settings varchar(2000) NOT NULL,
    token_settings varchar(2000) NOT NULL,
    PRIMARY KEY (id)
);
