/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.box.BoxGeneratorState;
import de.lwsystems.mailarchive.archive.box.IBoxGenerator;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.archive.container.IContainer;
import org.apache.log4j.Logger;

public abstract class AbstractBoxGenerator
implements IBoxGenerator {
    private final Logger logger = Logger.getLogger(AbstractBoxGenerator.class);
    private final IBoxHolder boxHolder;
    private final BoxGeneratorState state;

    protected AbstractBoxGenerator(IBoxHolder boxHolder, BoxGeneratorState state) throws ArchiveException {
        this.boxHolder = boxHolder;
        this.state = state;
        this.state.setBoxGenerator(this);
        this.state.setReadOnly(this.boxHolder.isReadOnly());
        this.state.checkBoxes();
    }

    @Override
    public final IBoxHolder getBoxHolder() {
        return this.boxHolder;
    }

    @Override
    public final IArchive getArchive() {
        IArchive archive = null;
        if (this.boxHolder != null) {
            archive = this.boxHolder.getArchive();
        }
        return archive;
    }

    @Override
    public final IContainer getContainer() {
        IContainer container = null;
        if (this.boxHolder != null) {
            container = this.boxHolder.getContainer();
        }
        return container;
    }

    @Override
    public BoxGeneratorState getState() {
        return this.state;
    }
}

