/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.container;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.AbstractArchive;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.container.IContainerGenerator;
import de.lwsystems.mailarchive.config.AbstractArchiveConfig;
import de.lwsystems.mailarchive.config.ContainerArchiveConfig;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import org.apache.log4j.Logger;
import org.apache.lucene.store.Directory;

public class ContainerArchive
extends AbstractArchive {
    private final Logger logger = Logger.getLogger(ContainerArchive.class);
    private final IContainerGenerator containerGenerator;

    public ContainerArchive(Benno benno, ContainerArchiveConfig config, boolean readOnly) throws ArchiveException {
        super(benno, config, config.identifier, readOnly);
        this.containerGenerator = config.containergenerator.getContainerGenerator(this, readOnly);
    }

    @Override
    public AbstractArchiveConfig getConfig() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public DocumentId addDocument(MailDocument document) throws NonFailingArchivingException, FailedArchivingException {
        DocumentId documentId = null;
        if (!this.doesMatch(document.getMetaData())) {
            throw new NonFailingArchivingException(document, "Document does not match archiving criteria");
        }
        documentId = this.containerGenerator.addDocument(document);
        return documentId;
    }

    @Override
    public boolean updateIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean rebuildIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean checkIntegrity() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean checkConsistency() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean optimizeIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean optimizeRepository() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        return this.getIdentifier() + " ContainerArchive";
    }

    @Override
    public Directory getIndexPath() {
        throw new UnsupportedOperationException("Not supported here!");
    }

    @Override
    public IContainerGenerator getContainerGenerator() {
        return this.containerGenerator;
    }
}

