/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.index;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.archive.index.AbstractIndex;
import de.lwsystems.mailarchive.archive.index.LuceneIndexWriter;
import de.lwsystems.mailarchive.config.AbstractIndexConfig;
import de.lwsystems.mailarchive.config.LuceneIndexConfig;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.Header;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.MailMetaData;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.james.mime4j.io.EOLConvertingInputStream;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;
import org.apache.tika.parser.ParsingReader;

public class LuceneIndex
extends AbstractIndex {
    private static final Logger LOGGER = Logger.getLogger(LuceneIndex.class);
    private boolean debugEnabled = LOGGER.isDebugEnabled();
    private final DateFormat dateFormat;
    private static final String UNINDEXEDHEADERS = "FROM:TO:CC:BCC:SUBJECT:DATE:CONTENT-TYPE:CONTENT-TRANSFER-ENCODING:MIME-VERSION";
    public static final Version STANDARDVERSION = Version.LUCENE_33;
    private final boolean readOnly;
    private final Version version;
    private LuceneIndexWriter LuceneIndexWriter;
    private IndexReader indexReader;
    private final Directory directory;

    public LuceneIndex(IBoxHolder boxHolder, String directory) throws ArchiveException {
        this(boxHolder, directory, true);
    }

    public LuceneIndex(IBoxHolder boxHolder, String directory, boolean readOnly) throws ArchiveException {
        this(boxHolder, new File(directory), STANDARDVERSION, readOnly);
    }

    public LuceneIndex(IBoxHolder boxHolder, String directory, Version version, boolean readOnly) throws ArchiveException {
        this(boxHolder, new File(directory), version, readOnly);
    }

    public LuceneIndex(IBoxHolder boxHolder, File directory) throws ArchiveException {
        this(boxHolder, directory, STANDARDVERSION, true);
    }

    public LuceneIndex(IBoxHolder boxHolder, File directory, boolean readOnly) throws ArchiveException {
        this(boxHolder, directory, STANDARDVERSION, readOnly);
    }

    public LuceneIndex(IBoxHolder boxHolder, File directory, Version version, boolean readOnly) throws ArchiveException {
        super(boxHolder);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new ArchiveException(this.getBoxHolder(), "Luceneindexdirectory canot be created. (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\"");
        }
        if (!directory.exists()) {
            throw new ArchiveException(this.getBoxHolder(), "Luceneindexdirectory cannot be created. (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\"");
        }
        if (!directory.isDirectory()) {
            throw new ArchiveException(this.getBoxHolder(), "Luceneindexdirectory is not a directory. (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\"");
        }
        if (!directory.canRead()) {
            throw new ArchiveException(this.getBoxHolder(), "Luceneindexdirectory cannot be read. (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\"");
        }
        if (!this.readOnly && !directory.canWrite() && this.debugEnabled) {
            String username = System.getProperty("user.name");
            LOGGER.debug((Object)("Lucene index directory \"" + directory.getAbsolutePath() + "\" is not writable for user " + username));
        }
        try {
            this.directory = FSDirectory.open((File)directory);
        }
        catch (IOException ex) {
            LOGGER.error((Object)"Directory cannot be opened", (Throwable)ex);
            throw new ArchiveException(boxHolder, ex);
        }
        this.dateFormat = new SimpleDateFormat("yyyyMMddHHmm", Locale.ROOT);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.version = version;
        this.readOnly = readOnly;
    }

    public LuceneIndex(IBoxHolder boxHolder, LuceneIndexConfig config) throws ArchiveException {
        this(boxHolder, config.directory, config.version, boxHolder.isReadOnly());
    }

    @Override
    public AbstractIndexConfig getConfig() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getIdentifier() {
        StringBuilder idString = new StringBuilder("LuceneIndex ");
        if (this.version == null) {
            idString.append("versionless");
        } else {
            idString.append(this.version.toString());
        }
        if (this.directory != null) {
            idString.append(": \"").append(this.directory.toString()).append("\"");
        }
        return idString.toString();
    }

    @Override
    public void addDocument(DocumentId mailId) throws FailedArchivingException {
        Document document = new Document();
        document.add((Fieldable)new Field("id", mailId.getFullDocumentId(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        MailMetaData metaData = mailId.getDocument().getMetaData();
        document.add((Fieldable)new NumericField("Date", Field.Store.YES, true).setLongValue(Long.parseLong(this.dateFormat.format(metaData.getDate()))));
        document.add((Fieldable)new Field("SortableDate", this.dateFormat.format(metaData.getDate()).toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        document.add((Fieldable)new NumericField("Size", Field.Store.YES, false).setIntValue(metaData.getSize()));
        String[] tempArray = metaData.getSenders();
        if (tempArray == null || tempArray.length == 0) {
            tempArray = metaData.getFroms();
        }
        this.addStrings(document, tempArray, "Sender", true);
        tempArray = metaData.getSenderDomains();
        if (tempArray == null || tempArray.length == 0) {
            tempArray = metaData.getFromDomains();
        }
        this.addStrings(document, tempArray, "SenderDomain", true);
        tempArray = metaData.getRecipients();
        if (tempArray == null || tempArray.length == 0) {
            tempArray = metaData.getFroms();
        }
        this.addStrings(document, tempArray, "Recipient", true);
        tempArray = metaData.getRecipientDomains();
        if (tempArray == null || tempArray.length == 0) {
            tempArray = metaData.getToDomains();
        }
        if (!metaData.isAttached()) {
            document.add((Fieldable)new Field("hasAttachment", "0", Field.Store.YES, Field.Index.NOT_ANALYZED));
        } else {
            document.add((Fieldable)new Field("hasAttachment", "1", Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        this.addStrings(document, tempArray, "RecipientDomain", false);
        this.addStrings(document, metaData.getFroms(), "From", true);
        this.addStrings(document, metaData.getFromDomains(), "FromDomain", false);
        this.addStrings(document, metaData.getTos(), "To", true);
        this.addStrings(document, metaData.getToDomains(), "ToDomain", false);
        this.addStrings(document, metaData.getCcs(), "Cc", true);
        this.addStrings(document, metaData.getCcDomains(), "CcDomain", false);
        this.addHeaders(document, metaData.getHeaders());
        this.addTikaField(document, "Text", mailId.getDocument().getMailStream());
        this.addDocument(document, mailId.getDocument());
    }

    private void addTikaField(Document document, String fieldname, InputStream inStream) {
        try {
            document.add((Fieldable)new Field(fieldname, (Reader)new ParsingReader((InputStream)new EOLConvertingInputStream(inStream)), Field.TermVector.NO));
        }
        catch (IOException ex) {
            LOGGER.warn((Object)ex);
        }
    }

    private void addHeaders(Document document, Header[] headers) {
        if (headers != null) {
            for (Header header : headers) {
                String name = header.getName().toUpperCase();
                if (UNINDEXEDHEADERS.indexOf(name) == -1) {
                    document.add((Fieldable)new Field("HEADER-" + name, header.getBody(), Field.Store.NO, Field.Index.ANALYZED));
                    continue;
                }
                if (!name.equals("SUBJECT")) continue;
                document.add((Fieldable)new Field("Subject", header.getBody(), Field.Store.YES, Field.Index.ANALYZED));
                document.add((Fieldable)new Field("SortableSubject", header.getBody(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            }
        }
    }

    private void addStrings(Document document, String[] tempArray, String fieldname, boolean store) {
        if (tempArray != null) {
            for (String text : tempArray) {
                document.add((Fieldable)new Field(fieldname, text, store ? Field.Store.YES : Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
            }
        }
    }

    private void addDocument(Document document, MailDocument mail) throws FailedArchivingException {
        boolean locked = false;
        try {
            locked = this.lockIndexWriter();
            this.LuceneIndexWriter.addDocument(document);
        }
        catch (LockObtainFailedException ex) {
            throw new FailedArchivingException(mail, "Index locked in 25 attempts", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            LOGGER.fatal((Object)("Cannot index message \"" + mail.toString()), (Throwable)ex);
            throw new FailedArchivingException(mail, ex);
        }
        finally {
            if (locked && this.LuceneIndexWriter != null) {
                this.LuceneIndexWriter.unlock();
            }
        }
    }

    private boolean lockIndexWriter() throws LockObtainFailedException, IOException {
        boolean locked = false;
        int retryCount = 0;
        while (!locked) {
            if (this.LuceneIndexWriter != null) {
                locked = this.LuceneIndexWriter.lock();
            }
            try {
                if (locked) continue;
                this.LuceneIndexWriter = new LuceneIndexWriter(this, this.directory, this.version);
            }
            catch (LockObtainFailedException ex) {
                if (++retryCount <= 25) continue;
                throw ex;
            }
        }
        return locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean optimize() {
        boolean locked = false;
        boolean successful = false;
        try {
            locked = this.lockIndexWriter();
            if (locked) {
                successful = this.LuceneIndexWriter.optimize();
            }
        }
        catch (IOException ex) {
            LOGGER.error((Object)ex);
        }
        finally {
            if (locked && this.LuceneIndexWriter != null) {
                this.LuceneIndexWriter.unlock();
            }
        }
        return locked;
    }

    @Override
    public Directory getDirectory() {
        return this.directory;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }
}

