/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.config;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.IArchiveGenerator;
import de.lwsystems.mailarchive.config.AbstractArchiveGeneratorConfig;
import de.lwsystems.mailarchive.config.AbstractBennoRestConfig;
import de.lwsystems.mailarchive.config.ConfiguredArchiveGeneratorConfig;
import de.lwsystems.mailarchive.config.ConfiguredBennoRestConfig;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementUnion;
import org.simpleframework.xml.Root;

@Root(name="benno")
public class BennoConfig {
    @ElementUnion(value={@Element(name="configuredarchives", type=ConfiguredArchiveGeneratorConfig.class)})
    public AbstractArchiveGeneratorConfig archiveGenerator;
    @Attribute(name="address", required=false)
    public String managementAddress = "127.0.0.1";
    @Attribute(name="management", required=false)
    public int managementPort = 2555;
    @Element(name="bennoRest", type=ConfiguredBennoRestConfig.class)
    public AbstractBennoRestConfig bennoRestConfig;
    @Element(name="log4jconfig", required=false)
    public String logConfig = "/etc/benno/bennocore-log4j.xml";

    public static BennoConfig getDefault() {
        BennoConfig config = new BennoConfig();
        config.archiveGenerator = AbstractArchiveGeneratorConfig.getDefault();
        return config;
    }

    public IArchiveGenerator getArchiveGenerator(Benno benno, boolean readOnly) {
        IArchiveGenerator archiveGen = null;
        if (this.archiveGenerator != null) {
            archiveGen = this.archiveGenerator.getArchiveGenerator(benno, readOnly);
        }
        return archiveGen;
    }
}

