/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.maildocument;

import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.utils.ConversionUtil;

public class DocumentId {
    private final IBoxHolder boxHolder;
    private final MailDocument document;
    private int duplicateId = 0;
    private String internalId = null;

    public int getDuplicateId() {
        return this.duplicateId;
    }

    public void setDuplicateId(int duplicateId) {
        this.duplicateId = duplicateId;
    }

    public void setDuplicateId(String duplicateIdHex) {
        this.duplicateId = ConversionUtil.fromHexToInt(duplicateIdHex);
    }

    public String getDuplicateIdHex() {
        return ConversionUtil.fromIntToHex(this.duplicateId);
    }

    public DocumentId(IBoxHolder boxHolder, MailDocument document) {
        this.boxHolder = boxHolder;
        this.document = document;
    }

    public DocumentId(IBoxHolder boxHolder, MailDocument document, int duplicateId) {
        this(boxHolder, document);
        this.duplicateId = duplicateId;
    }

    public DocumentId(IBoxHolder boxHolder, MailDocument document, int duplicateId, String internalId) {
        this(boxHolder, document, duplicateId);
        this.internalId = internalId;
    }

    public MailDocument getDocument() {
        return this.document;
    }

    public String getFullDocumentId() {
        return (this.internalId != null && this.internalId.length() > 0 ? this.internalId + ":" : "") + this.getHashHex() + this.getDuplicateIdHex();
    }

    public void setInternalId(String identifier) {
        this.internalId = identifier;
    }

    public String getHashHex() {
        return this.getDocument().getMetaData().getHashHex();
    }
}

