/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.maildocument;

import de.lwsystems.mailarchive.maildocument.MailMetaData;
import de.lwsystems.mailarchive.parser.BennoMailfileParser;
import de.lwsystems.mailarchive.parser.ParserException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="mail")
public class MailDocument {
    private static final Logger LOGGER = Logger.getLogger(MailDocument.class);
    private static final Properties emptyProperties = new Properties();
    @Element(name="mail")
    private final byte[] mailData;
    @Element(name="metadata")
    private final MailMetaData metaData;

    public MailDocument(byte[] mailData, MailMetaData metaData) {
        this.mailData = mailData;
        this.metaData = metaData;
    }

    public MailMetaData getMetaData() {
        return this.metaData;
    }

    public byte[] getMailData() {
        return this.mailData;
    }

    public InputStream getMailStream() {
        return new ByteArrayInputStream(this.getMailData());
    }

    public static final Session getSession() {
        return Session.getDefaultInstance((Properties)emptyProperties);
    }

    public MimeMessage getMimeMesage() throws MessagingException {
        return new MimeMessage(MailDocument.getSession(), this.getMailStream());
    }

    public boolean equals(MailDocument mailDocument) {
        return this.equals(mailDocument.getMailData());
    }

    public boolean equals(byte[] mailData) {
        boolean equal = true;
        if (this.mailData.length == mailData.length) {
            for (int i = 0; equal && i < mailData.length; ++i) {
                if (this.mailData[i] == mailData[i]) continue;
                equal = false;
            }
        } else {
            equal = false;
        }
        return equal;
    }

    public boolean equals(InputStream mailStream) {
        boolean equal = true;
        if (mailStream != null) {
            try {
                for (int i = 0; equal && i < this.mailData.length; ++i) {
                    int inbyte = mailStream.read();
                    if (inbyte != -1 && (this.mailData[i] & 0xFF) == inbyte) continue;
                    equal = false;
                }
                if (mailStream.read() != -1) {
                    equal = false;
                }
            }
            catch (IOException ex) {
                equal = false;
            }
            try {
                mailStream.close();
            }
            catch (IOException ex) {
                LOGGER.error((Object)ex);
            }
        } else {
            equal = false;
        }
        return equal;
    }

    public String toString() {
        String Message = this.metaData != null ? this.metaData.toString() : super.toString();
        return Message;
    }

    public void saveBennoMail(OutputStream outStream) throws IOException {
        this.appendBennoMail(outStream);
        outStream.flush();
        outStream.close();
    }

    public void appendBennoMail(OutputStream outStream) throws IOException {
        this.metaData.appendBennoHeaders(outStream);
        outStream.write(this.mailData);
    }

    public void saveMail(OutputStream outStream) throws IOException {
        this.appendMail(outStream);
        outStream.flush();
        outStream.close();
    }

    public void appendMail(OutputStream outStream) throws IOException {
        outStream.write(this.mailData);
    }

    public void saveMeta(OutputStream outStream) throws IOException {
        this.appendMeta(outStream);
        outStream.flush();
        outStream.close();
    }

    public void appendMeta(OutputStream outStream) throws IOException {
        try {
            this.metaData.Serialize(outStream);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException("Error serializing metadata", ex);
        }
    }

    public boolean equalsBenno(InputStream inStream) {
        boolean equal = false;
        try {
            equal = this.equals(new BennoMailfileParser().parseStream(inStream));
        }
        catch (ParserException ex) {
            LOGGER.error((Object)ex);
        }
        return equal;
    }
}

