/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.mailservice;

import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.IMailListener;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import de.lwsystems.mailarchive.mailservice.IMailService;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractMailService
implements IMailService {
    private static final Logger LOGGER = Logger.getLogger(AbstractMailService.class);
    protected List<IMailListener> listeners = new ArrayList<IMailListener>();
    protected volatile boolean running = false;
    protected volatile boolean starting = false;
    private boolean destroyed = false;

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public synchronized void destroy() {
        this.destroyed = true;
        this.stop();
        IMailListener[] listeners = new IMailListener[this.listeners.size()];
        for (IMailListener listener : listeners = this.listeners.toArray(listeners)) {
            this.removeMailListener(listener);
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean isStarting() {
        return this.starting;
    }

    @Override
    public void addMailListener(IMailListener listener) {
        if (!this.isDestroyed() && listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
            listener.addMailService(this);
        }
    }

    @Override
    public void removeMailListener(IMailListener listener) {
        if (listener != null && this.listeners.contains(listener)) {
            this.listeners.remove(listener);
            listener.removeMailService(this);
        }
    }

    protected boolean deliverMail(MailDocument mail) {
        boolean successful = true;
        if (!this.isDestroyed()) {
            for (IMailListener listener : this.listeners) {
                try {
                    DocumentId documentId = listener.addDocument(mail);
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info((Object)("Email archived as " + documentId.getFullDocumentId()));
                }
                catch (NonFailingArchivingException ex) {
                }
                catch (FailedArchivingException ex) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info((Object)("Problem archiving email " + ex));
                    }
                    successful = false;
                }
            }
        } else {
            successful = false;
        }
        return successful;
    }

    public String toString() {
        return this.getIdentifier();
    }
}

