/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.mailservice;

import de.lwsystems.mailarchive.mailservice.AbstractMailService;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class AbstractThreadedMailService
extends AbstractMailService
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(AbstractThreadedMailService.class);
    private Thread myThread;

    @Override
    public synchronized void start() {
        if (!this.isDestroyed()) {
            if (!this.starting) {
                this.starting = true;
            }
            if (this.myThread == null || !this.myThread.isAlive()) {
                this.myThread = new Thread((Runnable)this, this.getIdentifier());
                this.myThread.setDaemon(false);
            }
            if (this.myThread != null && !this.myThread.isAlive()) {
                this.myThread.start();
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (this.starting) {
            this.starting = false;
        }
        this.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.starting) {
                this.running = true;
                this.doRun();
            }
        }
        catch (Exception ex) {
            this.starting = false;
            LOGGER.log((Priority)Level.ERROR, (Object)("Exception in Thread " + this.getIdentifier()), (Throwable)ex);
        }
        finally {
            this.running = false;
        }
    }

    protected abstract void doRun() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        AbstractThreadedMailService abstractThreadedMailService = this;
        synchronized (abstractThreadedMailService) {
            this.notify();
        }
    }

    @Override
    public String getState() {
        String state = this.starting ? (this.myThread != null && this.myThread.isAlive() ? "running" : "starting") : (this.myThread != null && this.myThread.isAlive() ? "stopping" : "stopped");
        return state;
    }
}

