/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.mailservice;

import de.lwsystems.mailarchive.config.DirectoryWatchConfig;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.mailservice.AbstractThreadedMailService;
import de.lwsystems.mailarchive.parser.IFileParser;
import de.lwsystems.mailarchive.parser.MailfileParser;
import de.lwsystems.mailarchive.parser.ParserException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import org.apache.log4j.Logger;

public class DirectoryWatchService
extends AbstractThreadedMailService {
    private static final Logger LOGGER = Logger.getLogger(DirectoryWatchService.class);
    private static final long WATCHINTERVALL = 5000L;
    private static final long MAXFILES = 500L;
    protected static final String ERRORSUFFIX = ".err";
    private final IFileParser fileParser;
    private final File directory;
    private final String pattern;

    public DirectoryWatchService(String directory, String pattern) {
        this(new File(directory), pattern, new MailfileParser());
    }

    public DirectoryWatchService(File directory, String pattern, IFileParser fileParser) {
        if (this.directory == null) {
            throw new IllegalArgumentException("Directory must not be empty");
        }
        if (!this.directory.exists()) {
            throw new IllegalArgumentException("\"" + directory.getAbsolutePath() + "\" does not exist");
        }
        if (!this.directory.isDirectory()) {
            throw new IllegalArgumentException("\"" + directory.getAbsolutePath() + "\" is not a directory");
        }
        if (!this.directory.canRead()) {
            throw new IllegalArgumentException("Directory \"" + directory.getAbsolutePath() + "\" is not readable");
        }
        this.directory = directory;
        this.pattern = pattern == null || pattern.length() == 0 ? ".*" : pattern;
        if (fileParser == null) {
            throw new IllegalArgumentException("Fileparser must not be empty");
        }
        this.fileParser = fileParser;
    }

    public DirectoryWatchService(DirectoryWatchConfig config) {
        this.directory = new File(config.directory);
        this.pattern = config.pattern;
        this.fileParser = config.parser.getParser();
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj != null && obj instanceof DirectoryWatchService) {
            equal = this.directory.equals(((DirectoryWatchService)obj).directory) && this.pattern.equals(((DirectoryWatchService)obj).pattern);
        }
        return equal;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.directory != null ? this.directory.hashCode() : 0);
        hash = 97 * hash + (this.pattern != null ? this.pattern.hashCode() : 0);
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() throws Exception {
        while (this.starting) {
            long waitTime = System.currentTimeMillis() + 5000L;
            try {
                this.UpdateDirectory();
            }
            catch (Throwable ex) {
                LOGGER.error((Object)ex);
            }
            waitTime -= System.currentTimeMillis();
            DirectoryWatchService directoryWatchService = this;
            synchronized (directoryWatchService) {
                if (waitTime > 0L && waitTime < 5000L) {
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public String getIdentifier() {
        return "Directory watcher \"" + this.directory.getAbsolutePath() + "\"" + File.separator + "\"" + this.pattern + "\"";
    }

    private void UpdateDirectory() {
        if (this.directory == null) {
            throw new IllegalArgumentException("Directory became null, stopping directorywatcher");
        }
        String[] files = this.directory.list(new FilenameFilter(){
            private int count = 0;

            @Override
            public boolean accept(File dir, String name) {
                if ((long)this.count < 500L && name.matches(DirectoryWatchService.this.pattern) && !name.endsWith(DirectoryWatchService.ERRORSUFFIX) && new File(dir + File.separator + name).isFile()) {
                    ++this.count;
                    return true;
                }
                return false;
            }
        });
        if (files != null) {
            for (String filename : files) {
                if (!this.starting || filename == null) continue;
                File file = new File(this.directory.getAbsolutePath() + File.separator + filename);
                if (!file.exists()) {
                    LOGGER.info((Object)file);
                }
                try {
                    MailDocument document;
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info((Object)("Read file " + file.getAbsolutePath()));
                    }
                    if (this.deliverMail(document = this.fileParser.parseFile(file))) {
                        file.delete();
                        continue;
                    }
                    LOGGER.warn((Object)("Problem archiving email file " + file.getAbsolutePath()));
                    file.renameTo(new File(file.getAbsolutePath() + ERRORSUFFIX));
                }
                catch (FileNotFoundException ex) {
                    LOGGER.error((Object)"Listed file not found (had been removed before it could be read", (Throwable)ex);
                }
                catch (ParserException ex) {
                    LOGGER.error((Object)("Error parsing file \"" + file.getAbsolutePath() + "\""), (Throwable)ex);
                    file.renameTo(new File(file.getAbsolutePath() + ERRORSUFFIX));
                }
            }
        }
    }

    private void UpdateDirectory_Files() {
        if (this.directory == null) {
            throw new IllegalArgumentException("Directory ist null geworden");
        }
        File[] files = this.directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().matches(DirectoryWatchService.this.pattern) && !file.getName().endsWith(DirectoryWatchService.ERRORSUFFIX);
            }
        });
        if (files == null) {
            throw new IllegalArgumentException("Files ist null");
        }
        for (File file : files) {
            if (file == null) {
                throw new IllegalArgumentException("File ist null");
            }
            try {
                MailDocument document;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Read file " + file.getAbsolutePath()));
                }
                if (this.deliverMail(document = this.fileParser.parseFile(file))) {
                    file.delete();
                    continue;
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("Problem archiving email file " + file.getAbsolutePath()));
                }
                file.renameTo(new File(file.getAbsolutePath() + ERRORSUFFIX));
            }
            catch (FileNotFoundException ex) {
                LOGGER.error((Object)"Listed file not found (had been removed before it could be read", (Throwable)ex);
            }
            catch (ParserException ex) {
                LOGGER.error((Object)("Error parsing file \"" + file.getAbsolutePath() + "\""), (Throwable)ex);
                file.renameTo(new File(file.getAbsolutePath() + ERRORSUFFIX));
            }
        }
    }
}

