/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.utils;

import de.lwsystems.mailarchive.utils.LicenseException;
import de.lwsystems.mailarchive.utils.RunUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;

public final class License {
    static String intSec = "BglSZUTzkqQV7J9f1f6vEwGjuSKNxZ16Zsaw8r968KbReWAQ0HItemILuDtcAMRVYmeOR3X6";
    String licenseFileContent = "";
    String delimiter = ":";
    String typeIdentifier = "Type";
    String licenseKey = "LicenseKey";
    String expiresIdentifier = "Expires";
    String licenseeIdentifier = "Licensee";
    String maildomainIdentifier = "PrimaryMaildomain";
    String numMailboxesIdentifier = "Mailboxes";
    String hostInfoIdentifier = "Host-Info";
    String licenseType;
    String licenseString;
    String licenseExpires;
    String licensee;
    String mailDomain;
    String numMailboxes;
    String hostInfo;
    Date expires;
    Date buildTime;
    private static final Logger LOGGER = Logger.getLogger(License.class);
    boolean debugEnabled = LOGGER.isDebugEnabled();

    public License() {
    }

    public License(String filename) throws FileNotFoundException, IOException {
        String line;
        FileInputStream FileStream = new FileInputStream(filename);
        BufferedReader FileReader = new BufferedReader(new InputStreamReader(FileStream));
        while ((line = FileReader.readLine()) != null) {
            this.licenseFileContent = this.licenseFileContent + line + "\n";
            String[] splitLine = line.split(this.delimiter);
            String identifier = splitLine[0];
            if (identifier.length() == 0) continue;
            String value = splitLine[1].trim();
            if (identifier.equals(this.typeIdentifier)) {
                if (this.debugEnabled) {
                    LOGGER.debug((Object)("Detect license type: " + value));
                }
                this.licenseType = value;
                continue;
            }
            if (identifier.equals(this.hostInfoIdentifier)) {
                if (this.debugEnabled) {
                    LOGGER.debug((Object)("Detect host info: " + value));
                }
                this.hostInfo = value;
                continue;
            }
            if (identifier.equals(this.licenseKey)) {
                if (this.debugEnabled) {
                    LOGGER.debug((Object)("Detect license key: " + value));
                }
                this.licenseString = value;
            }
            if (identifier.equals(this.expiresIdentifier)) {
                if (this.debugEnabled) {
                    LOGGER.debug((Object)("Detect valid identifier: " + value));
                }
                this.licenseExpires = value;
            }
            if (identifier.equals(this.licenseeIdentifier)) {
                if (this.debugEnabled) {
                    LOGGER.debug((Object)("Detect licensee: " + value));
                }
                this.licensee = value;
            }
            if (identifier.equals(this.maildomainIdentifier)) {
                if (this.debugEnabled) {
                    LOGGER.debug((Object)("Detect primary maildomain: " + value));
                }
                this.mailDomain = value;
            }
            if (!identifier.equals(this.numMailboxesIdentifier)) continue;
            if (this.debugEnabled) {
                LOGGER.debug((Object)("Number of mailboxes: " + value));
            }
            this.numMailboxes = value;
        }
    }

    public boolean checkValid(String currentHostInfo) throws LicenseException {
        boolean licenseValid = false;
        String currentInfo = intSec + "_" + currentHostInfo + "_" + this.licenseExpires + "_" + this.licenseType + "_" + this.licensee + "_" + this.mailDomain + "_" + this.numMailboxes;
        String encodedCurrentInfo = this.encodeString(currentInfo);
        if (!encodedCurrentInfo.trim().equals(this.licenseString)) {
            throw new LicenseException("LICENSE CHECK FAILED");
        }
        String licenseInfo = intSec + "_" + this.hostInfo + "_" + this.licenseExpires + "_" + this.licenseType + "_" + this.licensee + "_" + this.mailDomain + "_" + this.numMailboxes;
        String encodedLicenseInfo = this.encodeString(licenseInfo);
        if (!encodedLicenseInfo.trim().equals(this.licenseString)) {
            throw new LicenseException("LICENSE FILE INVALID");
        }
        licenseValid = true;
        return licenseValid;
    }

    public boolean checkBuild() throws LicenseException {
        boolean retval = false;
        try {
            this.expires = License.getDate4String(this.licenseExpires);
            this.buildTime = License.getDate4String(RunUtil.buildDate);
            if (!this.expires.after(this.buildTime)) {
                throw new LicenseException("LICENSE INCOMPATIBLE");
            }
            retval = true;
        }
        catch (ParseException ex) {
            LOGGER.warn((Object)("Cannot read " + this.expiresIdentifier + " identifier"));
            if (this.debugEnabled) {
                LOGGER.debug((Object)ex);
            }
            throw new LicenseException("LICENSE FORMAT ERROR");
        }
        return retval;
    }

    public boolean checkExpire() throws LicenseException {
        boolean retval = true;
        try {
            this.expires = License.getDate4String(this.licenseExpires);
            GregorianCalendar yesterday = new GregorianCalendar();
            ((Calendar)yesterday).add(5, -1);
            if (this.expires.compareTo(yesterday.getTime()) < 0) {
                throw new LicenseException("LICENSE EXPIRED");
            }
            retval = false;
        }
        catch (ParseException ex) {
            LOGGER.warn((Object)("Cannot read " + this.expiresIdentifier + " identifier"));
            throw new LicenseException("LICENSE FORMAT ERROR");
        }
        return retval;
    }

    public String encodeString(String inputData) {
        String md5 = DigestUtils.md5Hex((String)inputData);
        String md5b64 = Base64.encodeBase64String((byte[])md5.getBytes());
        return md5b64.trim();
    }

    public static Date getDate4String(String dateString) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date retDate = formatter.parse(dateString);
        return retDate;
    }

    public String getHostInfo() throws UnknownHostException {
        InetAddress iaddr = InetAddress.getLocalHost();
        String address = iaddr.getHostAddress();
        String hostname = iaddr.getCanonicalHostName();
        return address + "/" + hostname;
    }

    public static String getIntSec() {
        return intSec;
    }

    public String getFile() {
        return this.licenseFileContent;
    }

    public String getType() {
        return this.licenseType;
    }

    public String getLicensee() {
        return this.licensee;
    }

    public String getMaildomain() {
        return this.mailDomain;
    }

    public String getNumMailboxes() {
        return this.numMailboxes;
    }
}

