/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.AbstractSingleIndexArchive;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.IBoxGenerator;
import de.lwsystems.mailarchive.config.AbstractArchiveConfig;
import de.lwsystems.mailarchive.config.SimpleArchiveConfig;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import org.apache.log4j.Logger;
import org.apache.lucene.store.Directory;

public class SimpleArchive
extends AbstractSingleIndexArchive {
    private static final Logger LOGGER = Logger.getLogger(SimpleArchive.class);
    private final IBoxGenerator boxGenerator;

    public SimpleArchive(Benno benno, SimpleArchiveConfig config, boolean readOnly) throws ArchiveException {
        super(benno, config, config.index, config.identifier, readOnly);
        this.boxGenerator = config.boxGenerator.getBoxGenerator(this, readOnly);
    }

    @Override
    public AbstractArchiveConfig getConfig() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public DocumentId addDocument(MailDocument document) throws FailedArchivingException, NonFailingArchivingException {
        DocumentId documentId = null;
        if (this.doesMatch(document.getMetaData())) {
            documentId = this.boxGenerator.addDocument(document);
            this.getIndex().addDocument(documentId);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Store email as " + documentId.getFullDocumentId()));
            }
        } else {
            throw new NonFailingArchivingException(document, "Document does not match archiving criteria");
        }
        return documentId;
    }

    @Override
    public boolean updateIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean rebuildIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean checkIntegrity() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean checkConsistency() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean optimizeRepository() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        return this.getIdentifier() + " SimpleArchive";
    }

    @Override
    public Directory getIndexPath() {
        throw new UnsupportedOperationException("Not supported here.");
    }
}

