/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.AbstractBoxGenerator;
import de.lwsystems.mailarchive.archive.box.BoxGeneratorState;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.archive.journal.ClosedBoxJournalEntry;
import de.lwsystems.mailarchive.config.AbstractFSBoxConfig;
import de.lwsystems.mailarchive.config.AbstractMultiFSBoxGeneratorConfig;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import java.io.File;
import org.apache.log4j.Logger;

public abstract class AbstractMultiFSBoxGenerator
extends AbstractBoxGenerator {
    private static final Logger LOGGER = Logger.getLogger(AbstractMultiFSBoxGenerator.class);
    private final File baseDirectory;
    private final boolean readOnly;

    private static BoxGeneratorState getBoxGeneratorState(AbstractMultiFSBoxGeneratorConfig config) {
        BoxGeneratorState state = null;
        File boxStateFile = new File(config.boxConfig.directory + File.separator + "boxstate.xml");
        if (boxStateFile.exists() && boxStateFile.canRead()) {
            try {
                state = (BoxGeneratorState)BoxGeneratorState.getPersister().read(BoxGeneratorState.class, boxStateFile);
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Error reading boxstate in \"" + boxStateFile.getAbsolutePath() + "\""), (Throwable)ex);
            }
        }
        if (state == null) {
            state = new BoxGeneratorState(config.boxConfig);
        }
        return state;
    }

    public AbstractMultiFSBoxGenerator(IBoxHolder boxHolder, AbstractMultiFSBoxGeneratorConfig config, boolean readOnly) throws ArchiveException {
        super(boxHolder, AbstractMultiFSBoxGenerator.getBoxGeneratorState(config));
        this.readOnly = readOnly;
        this.baseDirectory = new File(config.boxConfig.directory);
    }

    protected void saveState() throws ArchiveException {
        BoxGeneratorState state = this.getState();
        if (state != null) {
            AbstractFSBoxConfig config = (AbstractFSBoxConfig)state.getConfig();
            File directory = new File(config.directory);
            if (!directory.exists()) {
                if (this.readOnly) {
                    throw new ArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + directory.getAbsolutePath() + "\" does not exist.");
                }
                if (!directory.mkdirs()) {
                    throw new ArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + directory.getAbsolutePath() + "\" canot be created.");
                }
                if (!directory.exists()) {
                    throw new ArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + directory.getAbsolutePath() + "\" canot be created.");
                }
            }
            if (!directory.isDirectory()) {
                throw new ArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + directory.getAbsolutePath() + "\" is not a directory.");
            }
            if (!this.readOnly && !directory.canWrite()) {
                throw new ArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + directory.getAbsolutePath() + "\" is not a writeable.");
            }
            File boxStateFile = new File(config.directory + File.separator + "boxstate.xml");
            try {
                BoxGeneratorState.getPersister().write((Object)state, boxStateFile);
            }
            catch (Exception ex) {
                LOGGER.fatal((Object)("Error writing boxstate to \"" + boxStateFile.getAbsolutePath() + "\""), (Throwable)ex);
            }
        }
    }

    protected abstract String getActualBoxName();

    private synchronized IBox getBox(String boxName) throws ArchiveException {
        return this.getState().getBox(boxName);
    }

    private synchronized IBox getCurrentBox() throws ArchiveException {
        IBox box = null;
        if (!this.readOnly) {
            String boxName = this.getActualBoxName();
            if (boxName.equals(this.getState().getActualBoxName())) {
                box = this.getState().getActualBox();
            } else {
                IBox oldBox = this.getState().getActualBox();
                String oldHash = null;
                if (oldBox != null) {
                    oldHash = oldBox.closeBox();
                    box = ((AbstractFSBoxConfig)this.getState().getConfig()).getBox(this.getBoxHolder(), boxName, this.isReadOnly());
                    box.getJournal().addEntry(new ClosedBoxJournalEntry(oldBox.getIdentifier(), oldHash));
                } else {
                    box = ((AbstractFSBoxConfig)this.getState().getConfig()).getBox(this.getBoxHolder(), boxName, this.isReadOnly());
                }
                this.getState().setActualBox(box);
                this.saveState();
            }
        }
        return box;
    }

    @Override
    public DocumentId addDocument(MailDocument document) throws FailedArchivingException, NonFailingArchivingException {
        DocumentId docid = null;
        if (this.isReadOnly()) {
            throw new FailedArchivingException(document, "Archive \"" + this.getArchive().getIdentifier() + "\" is readonly");
        }
        try {
            IBox box = this.getCurrentBox();
            docid = box.addDocument(document);
            docid.setInternalId(box.getIdentifier());
        }
        catch (ArchiveException ex) {
            throw new FailedArchivingException(document, ex);
        }
        return docid;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }
}

