/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.container;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.condition.AbstractCondition;
import de.lwsystems.mailarchive.config.AbstractContainerConfig;
import de.lwsystems.mailarchive.maildocument.MailMetaData;
import org.apache.lucene.util.Version;

public abstract class AbstractContainer
implements IContainer {
    private final String identifier;
    private final IArchive archive;
    private AbstractCondition condition;
    private final boolean readOnly;

    public AbstractContainer(IArchive archive, AbstractCondition condition, String identifier, boolean readOnly) {
        this.archive = archive;
        this.condition = condition;
        this.identifier = identifier;
        this.readOnly = readOnly;
    }

    public AbstractContainer(IArchive archive, AbstractContainerConfig config, String identifier, boolean readOnly) {
        this.archive = archive;
        this.condition = config.condition.getCondition();
        this.identifier = identifier;
        this.readOnly = readOnly;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public final boolean doesMatch(MailMetaData metaData) {
        return this.condition.matches(metaData);
    }

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public String getState() {
        return this.isReadOnly() ? ", readonly" : "";
    }

    @Override
    public final Benno getBenno() {
        return this.archive.getBenno();
    }

    @Override
    public final IArchive getArchive() {
        return this.archive;
    }

    @Override
    public final IContainer getContainer() {
        return this;
    }

    @Override
    public IBox getBox() {
        throw new UnsupportedOperationException("Operation not supported yet");
    }

    @Override
    public Version getIndexVersion() {
        throw new UnsupportedOperationException("Operation not supported yet");
    }
}

