/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.container;

import de.lwsystems.mailarchive.archive.ArchiveNotFoundException;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.container.AbstractContainerGenerator;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractMapContainerGenerator
extends AbstractContainerGenerator {
    private final Logger LOGGER = Logger.getLogger(AbstractMapContainerGenerator.class);
    private final Map<String, IContainer> containers;

    protected final Map<String, IContainer> getContainerMap() {
        return this.containers;
    }

    @Override
    public final Iterable<IContainer> getContainers() {
        return this.containers.values();
    }

    public AbstractMapContainerGenerator(IArchive archive) {
        super(archive);
        this.containers = new HashMap<String, IContainer>();
    }

    public AbstractMapContainerGenerator(IArchive archive, Map<String, IContainer> map) {
        super(archive);
        this.containers = map;
    }

    @Override
    public final IContainer getContainer(String name) throws ArchiveNotFoundException {
        IContainer container = this.containers.get(name);
        if (container == null) {
            throw new ArchiveNotFoundException(name);
        }
        return container;
    }

    protected final void addContainer(String identifier, IContainer container) {
        this.containers.put(identifier, container);
    }

    @Override
    public DocumentId addDocument(MailDocument document) throws FailedArchivingException, NonFailingArchivingException {
        DocumentId documentId = null;
        for (IContainer container : this.getContainers()) {
            try {
                documentId = container.addDocument(document);
                if (!this.LOGGER.isDebugEnabled()) continue;
                this.LOGGER.debug((Object)("Store Message in container " + container.getIdentifier() + " as " + documentId.getFullDocumentId()));
            }
            catch (NonFailingArchivingException ex) {
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug((Object)("Message not archived in container \"" + container.getIdentifier() + "\""), (Throwable)ex);
                    continue;
                }
                this.LOGGER.info((Object)("Message not archived in container \"" + container.getIdentifier() + "\"" + ex));
            }
        }
        if (documentId == null) {
            throw new NonFailingArchivingException(document, "Document does not match archiving criteria of any container");
        }
        return documentId;
    }

    @Override
    public boolean optimizeIndex() {
        boolean successful = true;
        for (IContainer container : this.getContainers()) {
            successful = container.optimizeIndex() && successful;
        }
        return successful;
    }
}

