/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.container;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.IBoxGenerator;
import de.lwsystems.mailarchive.archive.container.AbstractSingleIndexContainer;
import de.lwsystems.mailarchive.archive.index.IIndex;
import de.lwsystems.mailarchive.config.AbstractArchiveConfig;
import de.lwsystems.mailarchive.config.SimpleContainerConfig;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import org.apache.log4j.Logger;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;

public class SimpleContainer
extends AbstractSingleIndexContainer {
    private final Logger logger = Logger.getLogger(SimpleContainer.class);
    private final IBoxGenerator boxGenerator;
    private final IIndex myIndex;

    public SimpleContainer(IArchive archive, SimpleContainerConfig config, boolean readOnly) throws ArchiveException {
        super(archive, config, config.index, config.identifier, readOnly);
        this.boxGenerator = config.boxGenerator.getBoxGenerator(this, readOnly);
        this.myIndex = config.index.getIndex(this.boxGenerator.getBoxHolder());
    }

    @Override
    public Directory getIndexPath() {
        return this.myIndex.getDirectory();
    }

    @Override
    public AbstractArchiveConfig getConfig() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public DocumentId addDocument(MailDocument document) throws FailedArchivingException, NonFailingArchivingException {
        DocumentId documentId = null;
        if (!this.doesMatch(document.getMetaData())) {
            throw new NonFailingArchivingException(document, "Document does not match archiving criteria");
        }
        documentId = this.boxGenerator.addDocument(document);
        this.getIndex().addDocument(documentId);
        return documentId;
    }

    @Override
    public boolean updateIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean rebuildIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean checkIntegrity() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean checkConsistency() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        return this.getIdentifier() + " SimpleArchive";
    }

    @Override
    public String getState() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean optimizeRepository() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public IBox getBox() {
        return this.boxGenerator.getState().getActualBox();
    }

    @Override
    public Version getIndexVersion() {
        return this.myIndex.getVersion();
    }
}

