/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.index;

import de.lwsystems.mailarchive.archive.index.LuceneIndex;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.ClassicAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;

public class LuceneIndexWriter
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(LuceneIndexWriter.class);
    private boolean debugEnabled = LOGGER.isDebugEnabled();
    private final LuceneIndex luceneIndex;
    private long expireMillis;
    private Lock writerLock = new ReentrantLock();
    private IndexWriter indexWriter;
    private static final long IDLEINTERVAL = 10000L;

    public LuceneIndexWriter(LuceneIndex luceneIndex, Directory directory, Version version) throws IOException {
        this.luceneIndex = luceneIndex;
        try {
            IndexWriterConfig config = new IndexWriterConfig(version, (Analyzer)new ClassicAnalyzer(version));
            config.setRAMBufferSizeMB(64.0);
            this.indexWriter = new IndexWriter(directory, config);
            this.setExpireMillis();
            new Thread((Runnable)this, this.luceneIndex.getIdentifier()).start();
        }
        catch (CorruptIndexException ex) {
            LOGGER.error((Object)"Corrupt index error opening indexwriter", (Throwable)ex);
            throw ex;
        }
        catch (LockObtainFailedException ex) {
            LOGGER.info((Object)"Lock Obtain error opening indexwriter", (Throwable)ex);
            throw ex;
        }
        catch (IOException ex) {
            LOGGER.error((Object)"IOError opening indexwriter", (Throwable)ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (this.lock()) {
            try {
                long waitMillis = this.expireMillis - System.currentTimeMillis();
                if (waitMillis <= 0L) {
                    try {
                        if (this.debugEnabled) {
                            LOGGER.debug((Object)"Commit changes on idle.");
                        }
                        this.indexWriter.commit();
                        this.indexWriter.close();
                        continue;
                    }
                    catch (CorruptIndexException ex) {
                        LOGGER.error((Object)"Corrupt index error closing indexwriter", (Throwable)ex);
                        continue;
                    }
                    catch (IOException ex) {
                        LOGGER.error((Object)"IOError closing indexwriter", (Throwable)ex);
                        continue;
                    }
                    finally {
                        this.indexWriter = null;
                        this.writerLock.unlock();
                        continue;
                    }
                }
                LuceneIndexWriter luceneIndexWriter = this;
                synchronized (luceneIndexWriter) {
                    this.writerLock.unlock();
                    try {
                        this.wait(waitMillis);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    continue;
                }
            }
            finally {
                if (this.indexWriter == null) continue;
                if (this.debugEnabled) {
                    LOGGER.debug((Object)"Lock indexer and commit changes.");
                }
                this.writerLock.lock();
                try {
                    this.indexWriter.commit();
                    this.indexWriter.close();
                    continue;
                }
                catch (CorruptIndexException ex1) {
                    if (!this.debugEnabled) continue;
                    LOGGER.debug((Object)"Corrupt index", (Throwable)ex1);
                    continue;
                }
                catch (IOException ex1) {
                    if (!this.debugEnabled) continue;
                    LOGGER.debug((Object)"IO error", (Throwable)ex1);
                    continue;
                }
                finally {
                    this.indexWriter = null;
                    this.writerLock.unlock();
                    continue;
                }
            }
            break;
        }
        return;
    }

    public boolean lock() {
        boolean valid = true;
        this.writerLock.lock();
        if (this.indexWriter == null) {
            valid = false;
            this.writerLock.unlock();
        }
        return valid;
    }

    public void unlock() {
        this.writerLock.unlock();
        this.setExpireMillis();
    }

    private void setExpireMillis() {
        this.expireMillis = System.currentTimeMillis() + 10000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(Document document) throws IOException {
        if (this.lock()) {
            try {
                try {
                    this.indexWriter.addDocument(document);
                }
                catch (Throwable ex) {
                    LOGGER.info((Object)ex);
                    this.indexWriter.addDocument(document);
                }
            }
            finally {
                this.unlock();
            }
        } else {
            throw new IOException("Indexwriter invalid!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean optimize() throws IOException {
        boolean successful = false;
        if (this.lock()) {
            try {
                this.indexWriter.optimize(true);
                successful = true;
            }
            finally {
                this.unlock();
            }
        } else {
            throw new IOException("Indexwriter invalid!");
        }
        return successful;
    }
}

