/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.config;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.AbstractFSBox;
import de.lwsystems.mailarchive.archive.box.FSHexMailBox;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.config.AbstractFSBoxConfig;
import de.lwsystems.mailarchive.config.FSJournalConfig;
import org.simpleframework.xml.Root;

@Root
public class FSHexMailBoxConfig
extends AbstractFSBoxConfig {
    public static FSHexMailBoxConfig getDefault() {
        return FSHexMailBoxConfig.getDefault("/srv/mailarchive/default/box_all");
    }

    public static FSHexMailBoxConfig getDefault(String directory) {
        FSHexMailBoxConfig config = new FSHexMailBoxConfig();
        config.directory = directory;
        config.setJournal(FSJournalConfig.getDefault());
        config.dirLength = 2;
        config.subdirs = 3;
        config.compression = IBox.CompressionType.gzip;
        return config;
    }

    @Override
    public FSHexMailBox getBox(IBoxHolder boxHolder, boolean readOnly) throws ArchiveException {
        return new FSHexMailBox(boxHolder, this, readOnly);
    }

    @Override
    public AbstractFSBox getBox(IBoxHolder boxHolder, String identifier, boolean readOnly) throws ArchiveException {
        return new FSHexMailBox(boxHolder, this, identifier, readOnly);
    }
}

