/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.container.IContainerGenerator;
import de.lwsystems.mailarchive.authentication.IAuthenticator;
import de.lwsystems.mailarchive.authentication.IBennoUserIdentity;
import de.lwsystems.mailarchive.authentication.IBennoUserIdentityService;
import de.lwsystems.mailarchive.condition.AbstractCondition;
import de.lwsystems.mailarchive.config.AbstractArchiveConfig;
import de.lwsystems.mailarchive.config.AbstractMailServiceConfig;
import de.lwsystems.mailarchive.maildocument.MailMetaData;
import de.lwsystems.mailarchive.mailservice.IMailService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractArchive
implements IArchive {
    private final Logger LOGGER = Logger.getLogger(AbstractArchive.class);
    private final String identifier;
    private final Benno benno;
    private AbstractCondition condition;
    private final boolean readOnly;
    private boolean running = false;
    private IAuthenticator authenticator = null;
    protected List<IMailService> services = new ArrayList<IMailService>();

    @Override
    public void addMailService(IMailService service) {
        if (service != null && !this.services.contains(service)) {
            this.services.add(service);
            service.addMailListener(this);
        }
    }

    @Override
    public void removeMailService(IMailService service) {
        if (service != null && this.services.contains(service)) {
            this.services.remove(service);
            service.removeMailListener(this);
        }
    }

    public AbstractArchive(Benno benno, AbstractArchiveConfig config, String identifier, boolean readOnly) throws ArchiveException {
        this.benno = benno;
        this.condition = config.condition.getCondition();
        this.identifier = identifier;
        this.readOnly = readOnly;
        this.running = true;
        if (!this.readOnly) {
            this.addMailServices(config.services);
        }
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public final boolean doesMatch(MailMetaData metaData) {
        return this.condition.matches(metaData);
    }

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final boolean isRunning() {
        return this.running;
    }

    @Override
    public String getState() {
        return (this.isRunning() ? "running" : "not running") + (this.isReadOnly() ? ", readonly" : "");
    }

    private void addMailServices(ArrayList<AbstractMailServiceConfig> services) {
        for (AbstractMailServiceConfig serviceConfig : services) {
            IMailService service = serviceConfig.getMailService();
            service = this.benno.registerService(service);
            this.addMailService(service);
        }
    }

    @Override
    public final Benno getBenno() {
        return this.benno;
    }

    @Override
    public final IArchive getArchive() {
        return this;
    }

    @Override
    public final IContainer getContainer() {
        return null;
    }

    @Override
    public IBennoUserIdentity loadUser(IBennoUserIdentityService identityService, String postfix, String username) {
        IBennoUserIdentity userIdentity = null;
        if (this.authenticator != null) {
            userIdentity = this.authenticator.loadUser(this, identityService, postfix, username);
        }
        return userIdentity;
    }

    @Override
    public Collection<IBennoUserIdentity> loadUsers(IBennoUserIdentityService identityService, String postfix) {
        Collection<IBennoUserIdentity> userIdentities = null;
        if (this.authenticator != null) {
            userIdentities = this.authenticator.loadUsers(this, identityService, postfix);
        }
        return userIdentities;
    }

    public IAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(IAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    @Override
    public IContainerGenerator getContainerGenerator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        for (IMailService service : this.services) {
            service.destroy();
        }
    }
}

