/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.config;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.container.ContainerArchive;
import de.lwsystems.mailarchive.config.AbstractArchiveConfig;
import de.lwsystems.mailarchive.config.ConditionMailDomainConfig;
import de.lwsystems.mailarchive.config.ConditionOrConfig;
import de.lwsystems.mailarchive.config.ConfiguredContainerGeneratorConfig;
import de.lwsystems.mailarchive.config.ContainerGeneratorConfig;
import de.lwsystems.mailarchive.config.DirectoryWatchConfig;
import java.io.IOException;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementUnion;
import org.simpleframework.xml.Root;

@Root
public class ContainerArchiveConfig
extends AbstractArchiveConfig {
    @ElementUnion(value={@Element(name="configuredcontainers", type=ConfiguredContainerGeneratorConfig.class)})
    public ContainerGeneratorConfig containergenerator;

    public static ContainerArchiveConfig getDefault(boolean readOnly) {
        ContainerArchiveConfig config = new ContainerArchiveConfig();
        config.identifier = "default";
        config.readOnly = readOnly;
        ConditionMailDomainConfig condition = ConditionMailDomainConfig.getDefault();
        config.condition = condition instanceof ConditionOrConfig ? (ConditionOrConfig)((Object)condition) : ConditionOrConfig.getDefault(condition);
        config.containergenerator = ConfiguredContainerGeneratorConfig.getDefault(readOnly);
        config.services.add(DirectoryWatchConfig.getDefault("/srv/mailarchive/inbox"));
        return config;
    }

    @Override
    public IArchive getArchive(Benno benno, boolean readOnly) throws ArchiveException, IOException {
        return new ContainerArchive(benno, this, readOnly);
    }
}

