/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.AbstractFSBennoBox;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.config.AbstractBoxConfig;
import de.lwsystems.mailarchive.config.FSHexBennoBoxConfig;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.MailMetaData;
import de.lwsystems.mailarchive.parser.BennoMailfileParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class FSHexBennoBox
extends AbstractFSBennoBox {
    public FSHexBennoBox(IBoxHolder boxHolder, FSHexBennoBoxConfig config, boolean readOnly) throws ArchiveException {
        super(boxHolder, config, readOnly);
    }

    public FSHexBennoBox(IBoxHolder boxHolder, FSHexBennoBoxConfig config, String identfier, boolean readOnly) throws ArchiveException {
        super(boxHolder, config, identfier, readOnly);
    }

    @Override
    public String getDocumentName(MailMetaData data) {
        return data.getHashHex();
    }

    @Override
    public AbstractBoxConfig getConfig() {
        FSHexBennoBoxConfig config = new FSHexBennoBoxConfig();
        this.setConfig(config);
        return config;
    }

    protected void setConfig(FSHexBennoBoxConfig config) {
        super.setConfig(config);
    }

    @Override
    public MailDocument getDocument(String id) {
        id.indexOf(":");
        String myIdentifier = id.substring(0, id.indexOf(":"));
        String myId = id.substring(id.indexOf(":") + 1);
        String myPath = this.getFileBaseForId(myIdentifier, myId) + this.getCompressionSuffix();
        File mailFile = new File(myPath);
        try {
            InputStream myStream = FSHexBennoBox.getInStream(mailFile, this.getCompression());
            return new BennoMailfileParser().parseStream(myStream);
        }
        catch (IOException ioex) {
            ioex.printStackTrace(System.out);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        return null;
    }

    @Override
    public MailMetaData getMetaData(String id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

