/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.container;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.ArchiveNotFoundException;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.container.IContainerGenerator;
import de.lwsystems.mailarchive.config.AbstractContainerConfig;
import de.lwsystems.mailarchive.config.ConfiguredContainerGeneratorConfig;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConfiguredContainerGenerator
implements IContainerGenerator {
    private static final Logger LOGGER = Logger.getLogger(ConfiguredContainerGenerator.class);
    private final Map<String, IContainer> containers;
    private final IArchive archive;

    public ConfiguredContainerGenerator(IArchive archive, ConfiguredContainerGeneratorConfig config, boolean readOnly) throws IOException {
        this.archive = archive;
        this.containers = new HashMap<String, IContainer>();
        for (AbstractContainerConfig container : config.containers) {
            try {
                this.addContainer(container.identifier, container.getContainer(archive, readOnly));
            }
            catch (ArchiveException ex) {
                LOGGER.error(null, (Throwable)ex);
            }
        }
    }

    @Override
    public final Benno getBenno() {
        return this.archive.getBenno();
    }

    @Override
    public final IArchive getArchive() {
        return this.archive;
    }

    protected final Map<String, IContainer> getContainerMap() {
        return this.containers;
    }

    @Override
    public final Iterable<IContainer> getContainers() {
        return this.containers.values();
    }

    @Override
    public final IContainer getContainer(String name) throws ArchiveNotFoundException {
        IContainer container = this.containers.get(name);
        if (container == null) {
            throw new ArchiveNotFoundException(name);
        }
        return container;
    }

    protected final void addContainer(String identifier, IContainer container) {
        this.containers.put(identifier, container);
    }

    @Override
    public DocumentId addDocument(MailDocument document) throws FailedArchivingException, NonFailingArchivingException {
        DocumentId documentId = null;
        int containerCounter = 0;
        for (IContainer container : this.getContainers()) {
            ++containerCounter;
            try {
                documentId = container.addDocument(document);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("Store Message in container " + container.getIdentifier() + " as " + documentId.getFullDocumentId()));
            }
            catch (NonFailingArchivingException ex) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Message not archived in container \"" + container.getIdentifier() + "\""), (Throwable)ex);
                    continue;
                }
                LOGGER.info((Object)("Message not archived in container \"" + container.getIdentifier() + "\"" + ex));
            }
        }
        if (containerCounter == 0) {
            throw new FailedArchivingException(document, "No write permission on any container");
        }
        if (documentId == null) {
            throw new NonFailingArchivingException(document, "Document does not match archiving criteria of any container");
        }
        return documentId;
    }

    public boolean optimizeIndex() {
        boolean successful = true;
        for (IContainer container : this.getContainers()) {
            successful = container.optimizeIndex() && successful;
        }
        return successful;
    }

    @Override
    public void shutdown() {
        for (IContainer container : this.getContainers()) {
            container.close();
        }
    }
}

