/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.journal;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.journal.FSJournal;
import de.lwsystems.mailarchive.config.AbstractJournalConfig;
import de.lwsystems.mailarchive.config.QuarterlyFSJournalConfig;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class QuarterlyFSJournal
extends FSJournal {
    private static final DateFormat DATEFORMAT = new SimpleDateFormat("yyyy", Locale.ROOT);

    public QuarterlyFSJournal(IBox box, File directory, boolean readOnly) throws ArchiveException {
        super(box, directory, readOnly);
    }

    public QuarterlyFSJournal(IBox box, QuarterlyFSJournalConfig config, File directory, boolean readOnly) throws ArchiveException {
        super(box, config, directory, readOnly);
    }

    @Override
    protected synchronized String getCurrentPart() {
        String date = DATEFORMAT.format(new Date());
        switch (Calendar.getInstance(Locale.ROOT).get(2)) {
            case 1: 
            case 2: 
            case 3: {
                date = date + "q1";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                date = date + "q2";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                date = date + "q3";
                break;
            }
            default: {
                date = date + "q4";
            }
        }
        return date;
    }

    @Override
    public QuarterlyFSJournalConfig getConfig() {
        QuarterlyFSJournalConfig config = new QuarterlyFSJournalConfig();
        this.setConfig(config);
        return config;
    }

    @Override
    protected void setConfig(AbstractJournalConfig config) {
        super.setConfig(config);
    }
}

