/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.condition;

import de.lwsystems.mailarchive.condition.AbstractCondition;
import de.lwsystems.mailarchive.config.ConditionAndConfig;
import de.lwsystems.mailarchive.maildocument.MailMetaData;
import java.util.ArrayList;

public class AndCondition
extends AbstractCondition {
    private final AbstractCondition[] conditions;

    public AndCondition(ConditionAndConfig config) {
        this.conditions = new AbstractCondition[config.conditions.size()];
        for (int i = 0; i < this.conditions.length; ++i) {
            this.conditions[i] = config.conditions.get(i).getCondition();
        }
    }

    private AndCondition(AbstractCondition[] conditions) {
        this.conditions = conditions;
    }

    @Override
    public boolean matches(MailMetaData metaData) {
        boolean bRet = true;
        for (int i = 0; bRet && i < this.conditions.length; ++i) {
            bRet = this.conditions[i].matches(metaData);
        }
        return bRet;
    }

    @Override
    public boolean isAlwaysTrue() {
        boolean bRet = true;
        for (int i = 0; bRet && i < this.conditions.length; ++i) {
            bRet = this.conditions[i].isAlwaysTrue();
        }
        return bRet;
    }

    @Override
    public boolean isAlwaysFalse() {
        boolean bRet = false;
        for (int i = 0; !bRet && i < this.conditions.length; ++i) {
            bRet = this.conditions[i].isAlwaysFalse();
        }
        return bRet;
    }

    @Override
    public AbstractCondition optimize() {
        AbstractCondition condition = this;
        if (this.conditions.length == 1) {
            condition = this.conditions[0].optimize();
        } else {
            ArrayList<AbstractCondition> newConditions = new ArrayList<AbstractCondition>(this.conditions.length);
            for (int i = 0; i < this.conditions.length; ++i) {
                if (this.conditions[i].isAlwaysTrue()) continue;
                newConditions.add(this.conditions[i]);
            }
            condition = newConditions.size() != this.conditions.length ? new AndCondition(newConditions.toArray(new AbstractCondition[newConditions.size()])).optimize() : super.optimize();
        }
        return condition;
    }
}

