/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.config;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.SimpleArchive;
import de.lwsystems.mailarchive.config.AbstractArchiveConfig;
import de.lwsystems.mailarchive.config.AbstractBoxGeneratorConfig;
import de.lwsystems.mailarchive.config.AbstractIndexConfig;
import de.lwsystems.mailarchive.config.ConditionAllConfig;
import de.lwsystems.mailarchive.config.ConditionOrConfig;
import de.lwsystems.mailarchive.config.DirectoryWatchConfig;
import de.lwsystems.mailarchive.config.LuceneIndexConfig;
import de.lwsystems.mailarchive.config.MinutelyFSBoxGeneratorConfig;
import de.lwsystems.mailarchive.config.MonthlyFSBoxGeneratorConfig;
import de.lwsystems.mailarchive.config.QuarterlyFSBoxGeneratorConfig;
import de.lwsystems.mailarchive.config.SingleFSBoxGeneratorConfig;
import de.lwsystems.mailarchive.config.WeeklyFSBoxGeneratorConfig;
import de.lwsystems.mailarchive.config.YearlyFSBoxGeneratorConfig;
import java.io.IOException;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementUnion;
import org.simpleframework.xml.Root;

@Root
public class SimpleArchiveConfig
extends AbstractArchiveConfig {
    @ElementUnion(value={@Element(name="luceneindex", type=LuceneIndexConfig.class)})
    public AbstractIndexConfig index;
    @ElementUnion(value={@Element(name="singlefsbox", type=SingleFSBoxGeneratorConfig.class), @Element(name="minutelyfsbox", type=MinutelyFSBoxGeneratorConfig.class), @Element(name="weeklyfsbox", type=WeeklyFSBoxGeneratorConfig.class), @Element(name="monthlyfsbox", type=MonthlyFSBoxGeneratorConfig.class), @Element(name="quarterlyfsbox", type=QuarterlyFSBoxGeneratorConfig.class), @Element(name="yearlyfsbox", type=YearlyFSBoxGeneratorConfig.class)})
    public AbstractBoxGeneratorConfig boxGenerator;

    public static SimpleArchiveConfig getDefault(boolean readOnly) {
        return SimpleArchiveConfig.getDefault("/srv/mailarchive/repo", "/srv/mailarchive/index", "/srv/mailarchive/inbox", readOnly);
    }

    public static SimpleArchiveConfig getDefault(String repoDir, String indexDir, String inboxDir, boolean readOnly) {
        SimpleArchiveConfig config = new SimpleArchiveConfig();
        config.identifier = "default";
        config.readOnly = readOnly;
        config.condition = ConditionOrConfig.getDefault(ConditionAllConfig.getDefault());
        config.index = LuceneIndexConfig.getDefault(indexDir);
        config.boxGenerator = AbstractBoxGeneratorConfig.getDefault(repoDir);
        config.services.add(DirectoryWatchConfig.getDefault(inboxDir));
        return config;
    }

    @Override
    public IArchive getArchive(Benno benno, boolean readOnly) throws ArchiveException, IOException {
        return new SimpleArchive(benno, this, this.readOnly && readOnly);
    }
}

