/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.config;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.container.SimpleContainer;
import de.lwsystems.mailarchive.config.AbstractBoxGeneratorConfig;
import de.lwsystems.mailarchive.config.AbstractConditionConfig;
import de.lwsystems.mailarchive.config.AbstractContainerConfig;
import de.lwsystems.mailarchive.config.AbstractIndexConfig;
import de.lwsystems.mailarchive.config.ConditionAllConfig;
import de.lwsystems.mailarchive.config.ConditionOrConfig;
import de.lwsystems.mailarchive.config.LuceneIndexConfig;
import de.lwsystems.mailarchive.config.MinutelyFSBoxGeneratorConfig;
import de.lwsystems.mailarchive.config.MonthlyFSBoxGeneratorConfig;
import de.lwsystems.mailarchive.config.QuarterlyFSBoxGeneratorConfig;
import de.lwsystems.mailarchive.config.SingleFSBoxGeneratorConfig;
import de.lwsystems.mailarchive.config.WeeklyFSBoxGeneratorConfig;
import de.lwsystems.mailarchive.config.YearlyFSBoxGeneratorConfig;
import java.io.IOException;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementUnion;
import org.simpleframework.xml.Root;

@Root
public class SimpleContainerConfig
extends AbstractContainerConfig {
    @ElementUnion(value={@Element(name="luceneindex", type=LuceneIndexConfig.class)})
    public AbstractIndexConfig index;
    @ElementUnion(value={@Element(name="singlefsbox", type=SingleFSBoxGeneratorConfig.class), @Element(name="minutelyfsbox", type=MinutelyFSBoxGeneratorConfig.class), @Element(name="weeklyfsbox", type=WeeklyFSBoxGeneratorConfig.class), @Element(name="monthlyfsbox", type=MonthlyFSBoxGeneratorConfig.class), @Element(name="quarterlyfsbox", type=QuarterlyFSBoxGeneratorConfig.class), @Element(name="yearlyfsbox", type=YearlyFSBoxGeneratorConfig.class)})
    public AbstractBoxGeneratorConfig boxGenerator;

    public static SimpleContainerConfig getDefault(boolean readOnly) {
        return SimpleContainerConfig.getDefault("default", "/srv/mailarchive/repo", "/srv/mailarchive/index", readOnly);
    }

    public static SimpleContainerConfig getDefault(String identifier, String repoDir, String indexDir, boolean readOnly) {
        return SimpleContainerConfig.getDefault(identifier, repoDir, indexDir, ConditionAllConfig.getDefault(), readOnly);
    }

    public static SimpleContainerConfig getDefault(String identifier, String repoDir, String indexDir, AbstractConditionConfig condition, boolean readOnly) {
        SimpleContainerConfig config = new SimpleContainerConfig();
        config.identifier = identifier;
        config.readOnly = readOnly;
        config.condition = condition instanceof ConditionOrConfig ? (ConditionOrConfig)condition : ConditionOrConfig.getDefault(condition);
        config.index = LuceneIndexConfig.getDefault(indexDir);
        config.boxGenerator = AbstractBoxGeneratorConfig.getDefault(repoDir);
        return config;
    }

    @Override
    public IContainer getContainer(IArchive archive, boolean readOnly) throws ArchiveException, IOException {
        return new SimpleContainer(archive, this, readOnly);
    }

    @Override
    public AbstractIndexConfig getIndex() {
        return this.index;
    }
}

