/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.maildocument;

import de.lwsystems.mailarchive.maildocument.Header;
import de.lwsystems.mailarchive.maildocument.MailMetaData;
import de.lwsystems.mailarchive.maildocument.PreviousArchive;
import de.lwsystems.mailarchive.utils.ListUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.mail.internet.AddressException;

public class TempMailMetaData {
    private final DateFormat dateFormat;
    private String hash = null;
    private String bennohash = null;
    private final ArrayList<String> senderList = new ArrayList();
    private final ArrayList<String> recipientList = new ArrayList();
    private final ArrayList<String> fromList = new ArrayList();
    private final ArrayList<String> toList = new ArrayList();
    private final ArrayList<String> ccList = new ArrayList();
    private final ArrayList<Header> headers = new ArrayList();
    private final ArrayList<PreviousArchive> archives = new ArrayList();
    private Date date = new Date();
    private boolean attached = false;
    private int size;
    private boolean defective = false;

    public TempMailMetaData() {
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.ROOT);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setBennoHash(String hash) {
        this.bennohash = hash;
    }

    public void addSender(String sender) throws AddressException {
        ListUtil.addAddressesToStringList(sender, this.senderList);
    }

    public void addRecipient(String recipient) throws AddressException {
        ListUtil.addAddressesToStringList(recipient, this.recipientList);
    }

    public void addFrom(String sender) throws AddressException {
        ListUtil.addAddressesToStringList(sender, this.fromList);
    }

    public void addTo(String toRecipient) throws AddressException {
        ListUtil.addAddressesToStringList(toRecipient, this.toList);
    }

    public void addCc(String ccRecipient) throws AddressException {
        ListUtil.addAddressesToStringList(ccRecipient, this.ccList);
    }

    public void addHeader(Header header) {
        if (!this.headers.contains(header)) {
            this.headers.add(header);
        }
    }

    public MailMetaData getMailMetaData() {
        return new MailMetaData(this.hash, this.bennohash, this.senderList.toArray(new String[this.senderList.size()]), this.recipientList.toArray(new String[this.recipientList.size()]), this.fromList.toArray(new String[this.fromList.size()]), this.toList.toArray(new String[this.toList.size()]), this.ccList.toArray(new String[this.ccList.size()]), this.getDate(), this.isAttached(), this.getSize(), this.headers.toArray(new Header[this.headers.size()]), this.archives.toArray(new PreviousArchive[this.archives.size()]), this.defective);
    }

    public String getHash() {
        return this.hash;
    }

    public String getBennoHash() {
        return this.bennohash;
    }

    public void addPreviousHash(String hash) {
        this.archives.add(new PreviousArchive(hash));
    }

    public void setPreviousDate(String date) {
        if (this.archives.size() == 0) {
            this.archives.add(new PreviousArchive("Unknown"));
        }
        this.archives.get(this.archives.size() - 1).setDate(date);
    }

    public void setPreviousName(String name) {
        if (this.archives.size() == 0) {
            this.archives.add(new PreviousArchive("Unknown"));
        }
        this.archives.get(this.archives.size() - 1).setName(name);
    }

    public boolean isDefective() {
        return this.defective;
    }

    public void setDefective(boolean defective) {
        this.defective = defective;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        if (date != null) {
            this.date = date;
        }
    }

    public boolean isAttached() {
        return this.attached;
    }

    public void setAttached(boolean attached) {
        this.attached = attached || this.attached;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setDate(String date) {
        try {
            this.setDate(this.dateFormat.parse(date));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setSize(String size) {
        try {
            this.setSize(Integer.parseInt(size));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

