/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.BoxState;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.IBoxGenerator;
import de.lwsystems.mailarchive.config.AbstractBoxConfig;
import de.lwsystems.mailarchive.config.FSB64BennoBoxConfig;
import de.lwsystems.mailarchive.config.FSB64MailBoxConfig;
import de.lwsystems.mailarchive.config.FSHexBennoBoxConfig;
import de.lwsystems.mailarchive.config.FSHexMailBoxConfig;
import java.util.HashMap;
import java.util.Map;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.ElementUnion;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.TreeStrategy;

@Root(name="boxstate")
public class BoxGeneratorState {
    private String actualBoxName = null;
    private IBox actualBox = null;
    @ElementMap(entry="box", key="identifier", attribute=true, inline=true, required=false)
    private HashMap<String, BoxState> boxes;
    @ElementUnion(value={@Element(name="fshexbennobox", type=FSHexBennoBoxConfig.class), @Element(name="fshexmailbox", type=FSHexMailBoxConfig.class), @Element(name="fsb64bennobox", type=FSB64BennoBoxConfig.class), @Element(name="fsb64mailbox", type=FSB64MailBoxConfig.class)})
    private AbstractBoxConfig config;
    private IBoxGenerator boxGenerator;
    private boolean readOnly = true;

    public static Persister getPersister() {
        return new Persister((Strategy)new TreeStrategy("type", "count"));
    }

    public BoxGeneratorState() {
    }

    public BoxGeneratorState(AbstractBoxConfig config) {
        this.config = config;
        this.boxes = new HashMap();
    }

    public void checkBoxes() throws ArchiveException {
        this.actualBoxName = null;
        for (Map.Entry<String, BoxState> entry : this.boxes.entrySet()) {
            if (entry.getValue().state != IBox.BOXSTATE.OPEN) continue;
            if (this.getActualBoxName() == null) {
                this.actualBoxName = entry.getKey();
                this.setActualBox(entry.getValue().getBox(this.boxGenerator.getBoxHolder(), this.isReadOnly()));
                continue;
            }
            throw new ArchiveException(this.boxGenerator.getBoxHolder(), "Boxgenerator with two open boxes \"" + this.getActualBoxName() + "\" and \"" + entry.getKey() + "\"");
        }
    }

    public HashMap<String, BoxState> getBoxes() {
        return this.boxes;
    }

    public AbstractBoxConfig getConfig() {
        return this.config;
    }

    public IBoxGenerator getBoxGenerator() {
        return this.boxGenerator;
    }

    void setBoxGenerator(IBoxGenerator boxGenerator) {
        this.boxGenerator = boxGenerator;
    }

    public IBox getBox(String boxName) throws ArchiveException {
        IBox box = null;
        if (boxName != null) {
            if (boxName.equals(this.actualBoxName)) {
                box = this.actualBox;
            } else if (this.boxes.containsKey(boxName)) {
                BoxState boxState = this.boxes.get(boxName);
                box = boxState.config.getBox(this.boxGenerator.getBoxHolder(), this.isReadOnly() || boxState.state != IBox.BOXSTATE.OPEN);
            }
        }
        return box;
    }

    public String getActualBoxName() {
        return this.actualBoxName;
    }

    public IBox getActualBox() {
        return this.actualBox;
    }

    public void setActualBox(IBox actualBox) {
        if (this.actualBox != null) {
            this.boxes.get((Object)this.actualBoxName).state = IBox.BOXSTATE.CLOSED;
        }
        this.actualBox = actualBox;
        this.actualBoxName = actualBox.getIdentifier();
        this.boxes.put(this.actualBoxName, new BoxState(actualBox.getConfig()));
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

