/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.container;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.IBoxGenerator;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.index.IIndex;
import de.lwsystems.mailarchive.condition.AbstractCondition;
import de.lwsystems.mailarchive.config.AbstractIndexConfig;
import de.lwsystems.mailarchive.config.SimpleContainerConfig;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.MailMetaData;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;

public class SimpleContainer
implements IBoxHolder,
IContainer {
    private final Logger LOGGER = Logger.getLogger(SimpleContainer.class);
    private final IBoxGenerator boxGenerator;
    private final IIndex index;
    private final String identifier;
    private final IArchive archive;
    private AbstractCondition condition;
    private final boolean readOnly;

    public SimpleContainer(IArchive archive, SimpleContainerConfig config, boolean readOnly) throws ArchiveException, IOException {
        this(archive, config, config.index, config.identifier, readOnly);
    }

    public SimpleContainer(IArchive archive, SimpleContainerConfig config, AbstractIndexConfig index, String identifier, boolean readOnly) throws ArchiveException, IOException {
        this.readOnly = readOnly;
        this.boxGenerator = config.boxGenerator.getBoxGenerator(this, readOnly);
        this.archive = archive;
        this.condition = config.condition.getCondition();
        this.identifier = identifier;
        this.index = index.getIndex(this);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public final boolean doesMatch(MailMetaData metaData) {
        return this.condition.matches(metaData);
    }

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public String getState() {
        return this.isReadOnly() ? ", readonly" : "";
    }

    @Override
    public final Benno getBenno() {
        return this.archive.getBenno();
    }

    @Override
    public final IArchive getArchive() {
        return this.archive;
    }

    @Override
    public final IContainer getContainer() {
        return this;
    }

    public IIndex getIndex() {
        return this.index;
    }

    @Override
    public boolean optimizeIndex() {
        return this.getIndex().optimize();
    }

    @Override
    public Directory getIndexPath() {
        return this.getIndex().getDirectory();
    }

    @Override
    public DocumentId addDocument(MailDocument document) throws FailedArchivingException, NonFailingArchivingException {
        DocumentId documentId = null;
        if (!this.doesMatch(document.getMetaData())) {
            if (this.LOGGER.isInfoEnabled()) {
                this.LOGGER.info((Object)("Email \"" + document.toString() + "\" does not match criteria of \"" + this.boxGenerator.getArchive().getIdentifier() + "\""));
            }
            throw new NonFailingArchivingException(document, "Document does not match archiving criteria");
        }
        documentId = this.boxGenerator.addDocument(document);
        this.getIndex().addDocument(documentId);
        return documentId;
    }

    @Override
    public void close() {
        this.getIndex().close();
    }

    public String toString() {
        return this.getIdentifier() + " SimpleArchive";
    }

    @Override
    public IBox getBox() {
        return this.boxGenerator.getState().getActualBox();
    }

    @Override
    public Version getIndexVersion() {
        return this.getIndex().getVersion();
    }
}

