/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.index;

import de.lwsystems.mailarchive.archive.index.MailContentHandler;
import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.lucene.document.Document;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TaggedInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.mail.RFC822Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class GracefulRFC882Parser
extends RFC822Parser {
    private static final long serialVersionUID = 8701157565517381006L;
    private Document document;

    public GracefulRFC882Parser(Document document) {
        this.document = document;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        MimeConfig config = new MimeConfig();
        config.setMaxLineLen(100000);
        config.setMaxHeaderCount(30000);
        config.setMaxHeaderLen(100000);
        config = (MimeConfig)context.get(MimeConfig.class, (Object)config);
        MimeStreamParser parser = new MimeStreamParser(config);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        MailContentHandler mch = new MailContentHandler(xhtml, metadata, context, config.isStrictParsing(), this.document);
        parser.setContentHandler((org.apache.james.mime4j.parser.ContentHandler)mch);
        parser.setContentDecoding(true);
        TaggedInputStream tagged = TaggedInputStream.get((InputStream)stream);
        try {
            parser.parse((InputStream)tagged);
        }
        catch (IOException e) {
            tagged.throwIfCauseOf((Exception)e);
            throw new TikaException("Failed to parse an email message", (Throwable)e);
        }
        catch (MimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TikaException) {
                throw (TikaException)cause;
            }
            if (cause instanceof SAXException) {
                throw (SAXException)cause;
            }
            throw new TikaException("Failed to parse an email message", (Throwable)e);
        }
    }
}

