/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.journal;

import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.journal.IJournal;
import de.lwsystems.mailarchive.archive.journal.JournalEntry;
import de.lwsystems.mailarchive.config.AbstractJournalConfig;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public abstract class AbstractJournal
implements IJournal {
    private boolean readOnly;
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.ROOT);
    private IBox box;

    public AbstractJournal(IBox box, boolean readOnly) {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.box = box;
        this.readOnly = readOnly;
    }

    protected String formatEntry(JournalEntry entry) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.dateFormat.format(entry.getDate())).append(": (");
        stringBuilder.append(entry.getState().toString()).append(") ");
        stringBuilder.append(entry.getMessage());
        return stringBuilder.toString();
    }

    @Override
    public abstract void addEntry(JournalEntry var1);

    @Override
    public String getIdentifier() {
        return this.getBox().getIdentifier();
    }

    public IBox getBox() {
        return this.box;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    protected final void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    protected void setConfig(AbstractJournalConfig config) {
    }
}

