/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.journal;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.AbstractBox;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.journal.AbstractJournal;
import de.lwsystems.mailarchive.archive.journal.CloseJournalEntry;
import de.lwsystems.mailarchive.archive.journal.JournalEntry;
import de.lwsystems.mailarchive.archive.journal.StartJournalEntry;
import de.lwsystems.mailarchive.config.AbstractJournalConfig;
import de.lwsystems.mailarchive.config.FSJournalConfig;
import de.lwsystems.mailarchive.utils.ConversionUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Logger;

public class FSJournal
extends AbstractJournal {
    protected static final String JOURNALSUFFIX = ".journal";
    protected static final String JOURNALFILE = "current";
    protected static final int BUFFERSIZE = 1024;
    private static final Logger LOGGER = Logger.getLogger(FSJournal.class);
    private final File directory;
    private File logfile;
    private String currentPart;

    public FSJournal(IBox box, File directory, boolean readOnly) throws ArchiveException {
        block12: {
            super(box, readOnly);
            this.directory = directory;
            if (!this.directory.exists()) {
                if (readOnly) {
                    throw new ArchiveException(this.getBox().getBoxHolder(), "Journaldirectory \"" + this.directory.getAbsolutePath() + "\" canot be created. (" + this.getIdentifier() + ")");
                }
                if (!this.directory.mkdirs()) {
                    throw new ArchiveException(this.getBox().getBoxHolder(), "Journaldirectory \"" + this.directory.getAbsolutePath() + "\" canot be created. (" + this.getIdentifier() + ")");
                }
                if (!this.directory.exists()) {
                    throw new ArchiveException(this.getBox().getBoxHolder(), "Journaldirectory \"" + this.directory.getAbsolutePath() + "\" canot be created. (" + this.getIdentifier() + ")");
                }
            }
            if (!this.directory.isDirectory()) {
                throw new ArchiveException(this.getBox().getBoxHolder(), "Journaldirectory \"" + this.directory.getAbsolutePath() + "\" is not a directory. (" + this.getIdentifier() + ")");
            }
            if (!readOnly) {
                if (!this.directory.canWrite()) {
                    throw new ArchiveException(this.getBox().getBoxHolder(), "Journaldirectory \"" + this.directory.getAbsolutePath() + "\" is not a writeable. (" + this.getIdentifier() + ")");
                }
                this.logfile = this.getCurrentFile();
                if (this.logfile.exists()) {
                    try {
                        BufferedReader reader = new BufferedReader(new FileReader(this.logfile));
                        String firstLine = reader.readLine();
                        if (!firstLine.contains(": (SUCCESS) START      \"")) {
                            LOGGER.fatal((Object)("invalid Journal \"" + this.logfile.getAbsolutePath() + "\""));
                            this.currentPart = "Invalid";
                            break block12;
                        }
                        this.currentPart = firstLine.split("\"")[1];
                    }
                    catch (Throwable ex) {
                        LOGGER.fatal((Object)("invalid Journal \"" + this.logfile.getAbsolutePath() + "\""), ex);
                        this.currentPart = "Invalid";
                    }
                } else {
                    this.currentPart = "---";
                }
            }
        }
    }

    public FSJournal(IBox box, FSJournalConfig config, File directory, boolean readOnly) throws ArchiveException {
        this(box, directory, readOnly);
    }

    protected File getCurrentFile() {
        return new File(this.directory.getAbsolutePath() + File.separator + JOURNALFILE + JOURNALSUFFIX);
    }

    protected String getCurrentPart() {
        return "all";
    }

    private String getNewPart() {
        String newPart = this.getCurrentPart();
        int i = 2;
        while (new File(this.directory.getAbsoluteFile() + File.separator + newPart + JOURNALSUFFIX + this.getBox().getCompressionSuffix()).exists()) {
            newPart = this.getCurrentPart() + "-" + Integer.toString(i);
            ++i;
        }
        return newPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String closeJournal() {
        String hash = "";
        if (!this.isReadOnly()) {
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                BufferedInputStream source = null;
                try {
                    source = new BufferedInputStream(new FileInputStream(this.logfile));
                    byte[] buffer = new byte[1024];
                    int bytesRead = source.read(buffer);
                    while (bytesRead >= 0) {
                        digest.update(buffer, 0, bytesRead);
                        bytesRead = source.read(buffer);
                    }
                    source.close();
                    hash = ConversionUtil.fromBytesToHex(digest.digest());
                    this.addEntry(new CloseJournalEntry(hash));
                }
                catch (FileNotFoundException ex) {
                    LOGGER.error((Object)ex);
                }
                catch (IOException ex) {
                    LOGGER.error((Object)ex);
                }
                finally {
                    try {
                        if (source != null) {
                            source.close();
                        }
                    }
                    catch (IOException ex) {
                        LOGGER.error((Object)ex);
                    }
                }
            }
            catch (NoSuchAlgorithmException ex) {
                LOGGER.error((Object)ex);
            }
            hash = this.moveJournal();
            this.setReadOnly(true);
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String moveJournal() {
        String hash = "";
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            OutputStream destination = null;
            BufferedInputStream source = null;
            try {
                destination = AbstractBox.getOutStream(new File(this.directory.getAbsoluteFile() + File.separator + this.currentPart + JOURNALSUFFIX + this.getBox().getCompressionSuffix()));
                source = new BufferedInputStream(new FileInputStream(this.logfile));
                byte[] buffer = new byte[1024];
                int bytesRead = source.read(buffer);
                while (bytesRead >= 0) {
                    digest.update(buffer, 0, bytesRead);
                    destination.write(buffer, 0, bytesRead);
                    bytesRead = source.read(buffer);
                }
                destination.close();
                source.close();
                this.logfile.delete();
            }
            catch (FileNotFoundException ex) {
                LOGGER.error((Object)ex);
            }
            catch (IOException ex) {
                LOGGER.error((Object)ex);
            }
            finally {
                try {
                    if (source != null) {
                        source.close();
                    }
                }
                catch (IOException ex) {
                    LOGGER.error((Object)ex);
                }
                try {
                    if (destination != null) {
                        destination.close();
                    }
                }
                catch (IOException ex) {
                    LOGGER.error((Object)ex);
                }
            }
            hash = ConversionUtil.fromBytesToHex(digest.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.error((Object)ex);
        }
        return hash;
    }

    protected void checkPart() throws IOException {
        if (!this.isReadOnly()) {
            if (this.logfile == null) {
                this.logfile = this.getCurrentFile();
            }
            if (this.logfile.exists()) {
                String current = this.getNewPart();
                if (!current.equals(this.currentPart)) {
                    String oldHash = this.moveJournal();
                    String oldPart = this.currentPart;
                    this.logfile = this.getCurrentFile();
                    this.currentPart = current;
                    this.writeEntry(new StartJournalEntry(this.currentPart, oldPart, oldHash));
                }
            } else {
                this.currentPart = this.getNewPart();
                this.logfile.createNewFile();
                this.writeEntry(new StartJournalEntry(this.currentPart));
            }
        }
    }

    @Override
    public synchronized void addEntry(JournalEntry entry) {
        if (!this.isReadOnly()) {
            try {
                this.checkPart();
                this.writeEntry(entry);
            }
            catch (IOException ex) {
                LOGGER.fatal((Object)("Unable to write Journalentry \"" + entry.toString()), (Throwable)ex);
            }
        }
    }

    private void writeEntry(JournalEntry entry) throws IOException {
        OutputStreamWriter journalWriter = new OutputStreamWriter(new FileOutputStream(this.logfile, true));
        journalWriter.write(this.formatEntry(entry));
        journalWriter.write("\n");
        journalWriter.flush();
        journalWriter.close();
    }

    @Override
    public FSJournalConfig getConfig() {
        FSJournalConfig config = new FSJournalConfig();
        this.setConfig(config);
        return config;
    }

    @Override
    protected void setConfig(AbstractJournalConfig config) {
        super.setConfig(config);
    }
}

