/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.condition;

import de.lwsystems.mailarchive.condition.AbstractCondition;
import de.lwsystems.mailarchive.config.ConditionMailDomainConfig;
import de.lwsystems.mailarchive.maildocument.MailMetaData;

public class MailDomainCondition
extends AbstractCondition {
    private final boolean matchSender;
    private final boolean matchRecipient;
    private final boolean matchFrom;
    private final boolean matchTo;
    private final boolean matchCc;
    private String domain;

    public MailDomainCondition(ConditionMailDomainConfig config) {
        this.matchSender = config.matchSender;
        this.matchRecipient = config.matchRecipient;
        this.matchFrom = config.matchFrom;
        this.matchTo = config.matchTo;
        this.matchCc = config.matchCc;
        this.domain = config.domain;
    }

    @Override
    public boolean matches(MailMetaData metaData) {
        boolean bRet = false;
        bRet = bRet || this.matchSender && metaData.matchSenderDomain(this.domain);
        bRet = bRet || this.matchRecipient && metaData.matchRecipientDomain(this.domain);
        bRet = bRet || this.matchFrom && metaData.matchFromDomain(this.domain);
        bRet = bRet || this.matchTo && metaData.matchToDomain(this.domain);
        bRet = bRet || this.matchCc && metaData.matchCcDomain(this.domain);
        return bRet;
    }

    @Override
    public boolean isAlwaysTrue() {
        return !this.isAlwaysFalse() && this.domain.length() == 0;
    }

    @Override
    public boolean isAlwaysFalse() {
        return !this.matchSender && !this.matchRecipient && !this.matchFrom && !this.matchTo && !this.matchCc;
    }
}

