/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.utils;

import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.parser.MailfileParser;
import de.lwsystems.mailarchive.parser.ParserException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.lucene.store.Directory;

public class TestUtils {
    public static DocumentId parseStream(InputStream inputStream) throws URISyntaxException, FileNotFoundException, ParserException {
        MailfileParser parser = new MailfileParser();
        MailDocument doc = parser.parseStream(inputStream);
        DocumentId docId = new DocumentId(new TestBoxHolder(), doc);
        return docId;
    }

    public static DocumentId parseFile(URI uri) throws URISyntaxException, FileNotFoundException, ParserException {
        MailfileParser parser = new MailfileParser();
        File file = new File(uri);
        MailDocument doc = parser.parseFile(file);
        DocumentId docId = new DocumentId(new TestBoxHolder(), doc);
        return docId;
    }

    public static String stackTraceToString(Exception e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        e.printStackTrace(ps);
        try {
            return baos.toString("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static class TestBoxHolder
    implements IBoxHolder {
        IContainer container;

        @Override
        public String getIdentifier() {
            return "test";
        }

        @Override
        public IArchive getArchive() {
            return null;
        }

        @Override
        public IContainer getContainer() {
            return this.container;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public Directory getIndexPath() {
            return null;
        }

        @Override
        public void close() {
        }
    }
}

